# QICore MedicationDispense - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore MedicationDispense 

 
Profile of MedicationDispense for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* medication[x]: (QI) What medication was supplied
* subject: (QI) Who the dispense is for
* status: (QI) preparation | in-progress | cancelled | on-hold | completed | entered-in-error | stopped | declined | unknown

**QI Elements:**
* authorizingPrescription: (QI) Medication order that authorizes the dispense
* extension(recorded): (QI) When recorded
* dosageInstruction: (QI) How the medication is to be used by the patient or administered by the caregiver
* medication[x].extension(codeOptions): (QI) Url of a value set of candidate medications
* daysSupply: (QI) Amount of medication expressed as a timing amount
* whenPrepared: (QI) When product was packaged and reviewed
* quantity: (QI) Amount dispensed
* whenHandedOver: (QI) When product was given out or mailed
* type: (QI) Trial fill, partial fill, emergency fill, etc.

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationDispense profile defines the conformance expectations for a MedicationDispense event, regardless of whether it is a positive or negative statement. The MedicationDispenseDone and MedicationDispenseDeclined profiles represent the positive and negative statements for a MedicationDispense event.

To create an expression indicating existence of a MedicationDispense event, use the profile [QICoreMedicationDispenseDone](StructureDefinition-qicore-medicationdispensedone.md); to specifically request information that a MedicationDispense intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationDispenseDeclined](StructureDefinition-qicore-medicationdispensedeclined.md).

The following example illustrates the use of the MedicationDispense profile

```
define "Dementia Medication Dispensed":
  ["MedicationDispense": "Dementia Medications"] MedicationDispense
    where MedicationDispense.status in { 'active', 'completed', 'on-hold' }
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Penicillin MedicationDispense Example](MedicationDispense-example.md) |
| [MedicationDispense Cumulative Duration Example](MedicationDispense-cmd-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md) and [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md)
* Examples for this Profile: [MedicationDispense/cmd-example](MedicationDispense-cmd-example.md) and [MedicationDispense/example](MedicationDispense-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationdispense)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationdispense.csv), [Excel](../StructureDefinition-qicore-medicationdispense.xlsx), [Schematron](../StructureDefinition-qicore-medicationdispense.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationdispense",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationDispense"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispense",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationDispense",
  "title" : "QICore MedicationDispense",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of MedicationDispense for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense",
        "constraint" : [
          {
            "key" : "mdp-1",
            "severity" : "error",
            "human" : "To indicate what medication, either a reference to a Medication, or at least one coding in the medication or a codeOptions extension shall be provided",
            "expression" : "(medication is Reference).not() implies medication.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor medication.coding.exists()",
            "xpath" : "exists(f:extension)"
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension:recorded",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.extension",
        "sliceName" : "recorded",
        "short" : "(QI) When recorded",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.recorded"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.status",
        "short" : "(QI) preparation | in-progress | cancelled | on-hold | completed | entered-in-error | stopped | declined | unknown"
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.medication[x]",
        "short" : "(QI) What medication was supplied",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "The set of RxNorm codes to represent medications",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        }
      },
      {
        "id" : "MedicationDispense.medication[x].extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.medication[x].extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate medications",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the medication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/codeOptions|8.0.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.subject",
        "short" : "(QI) Who the dispense is for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.authorizingPrescription",
        "short" : "(QI) Medication order that authorizes the dispense",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.type",
        "short" : "(QI) Trial fill, partial fill, emergency fill, etc.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType"
        }
      },
      {
        "id" : "MedicationDispense.quantity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.quantity",
        "short" : "(QI) Amount dispensed"
      },
      {
        "id" : "MedicationDispense.daysSupply",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.daysSupply",
        "short" : "(QI) Amount of medication expressed as a timing amount"
      },
      {
        "id" : "MedicationDispense.whenPrepared",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.whenPrepared",
        "short" : "(QI) When product was packaged and reviewed",
        "comment" : "When used as part of a cumulative medication duration calculation, the whenPrepared element is used if whenHandedOver is not available to determine a starting point for the period covered by the dispense.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.whenHandedOver",
        "short" : "(QI) When product was given out or mailed"
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.dosageInstruction",
        "short" : "(QI) How the medication is to be used by the patient or administered by the caregiver"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.text",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.dosageInstruction.text",
        "short" : "(QI) Free text dosage instructions e.g. SIG"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.dosageInstruction.timing",
        "short" : "(QI) When medication should be administered"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.dosageInstruction.doseAndRate",
        "short" : "(QI) Amount of medication administered"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "short" : "(QI) Amount of medication per dose",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          },
          {
            "code" : "Range"
          }
        ]
      }
    ]
  }
}

```
