# QICore MedicationAdministration - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore MedicationAdministration 

 
Profile of MedicationAdministration for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* status: (QI) in-progress | not-done | on-hold | completed | entered-in-error | stopped | unknown
* medication[x]: (QI) What was administered
* dosage: (QI) Details of how medication was taken
* medication[x].extension(codeOptions): (QI) Url of a value set of candidate medications
* subject: (QI) Who received medication
* request: (QI) Request administration performed against
* effective[x]: (QI) Start and end time of administration
* context: (QI) Encounter or Episode of Care administered as part of

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationAdministration profile defines the conformance expectations for a MedicationAdministration event, regardless of whether it is a positive or negative statement. The MedicationAdministrationDone and MedicationAdministrationNotDone profiles represent the positive and negative statements for a MedicationAdministration event.

To create an expression indicating existence of a MedicationAdministration, use the profile [QICoreMedicationAdministrationDone](StructureDefinition-qicore-medicationadministrationdone.md); to specifically request information that a MedicationAdministration intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationAdministrationNotDone](StructureDefinition-qicore-medicationadministrationnotdone.md).

The following example illustrates accessing MedicationAdministration data:

```
define "Low Dose Unfractionated Heparin Administration":
  ["MedicationAdministration": medication in "Low Dose Unfractionated Heparin for VTE Prophylaxis"] VTEMedication
    where VTEMedication.status = 'completed'
      and VTEMedication.category ~ QICoreCommon."Inpatient"
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Inhalant Example](MedicationAdministration-example.md) |
| [Cumulative Duration Example](MedicationAdministration-cmd-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore MedicationAdministration Done](StructureDefinition-qicore-medicationadministrationdone.md) and [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md)
* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md)
* Examples for this Profile: [MedicationAdministration/cmd-example](MedicationAdministration-cmd-example.md), [MedicationAdministration/done-example](MedicationAdministration-done-example.md) and [MedicationAdministration/example](MedicationAdministration-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationadministration)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationadministration.csv), [Excel](../StructureDefinition-qicore-medicationadministration.xlsx), [Schematron](../StructureDefinition-qicore-medicationadministration.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationadministration",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationAdministration"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministration",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationAdministration",
  "title" : "QICore MedicationAdministration",
  "status" : "draft",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of MedicationAdministration for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationAdministration",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationAdministration",
        "path" : "MedicationAdministration",
        "constraint" : [
          {
            "key" : "qma-1",
            "severity" : "error",
            "human" : "To indicate what medication, either a reference to a Medication or at least one coding in the medication or a codeOptions extension shall be provided",
            "expression" : "(medication is Reference).not() implies medication.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor medication.coding.exists()",
            "xpath" : "exists(f:extension)"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "MedicationAdministration.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.status",
        "short" : "(QI) in-progress | not-done | on-hold | completed | entered-in-error | stopped | unknown"
      },
      {
        "id" : "MedicationAdministration.medication[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.medication[x]",
        "short" : "(QI) What was administered",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication"
            ]
          }
        ],
        "condition" : ["qma-1"],
        "binding" : {
          "strength" : "preferred",
          "description" : "The set of RxNorm codes to represent medications",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        }
      },
      {
        "id" : "MedicationAdministration.medication[x].extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.medication[x].extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate medications",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the medication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/codeOptions|8.0.0-ballot"
            ]
          }
        ],
        "condition" : ["qma-1"]
      },
      {
        "id" : "MedicationAdministration.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.subject",
        "short" : "(QI) Who received medication",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.context",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.context",
        "short" : "(QI) Encounter or Episode of Care administered as part of",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter",
              "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.effective[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.effective[x]",
        "short" : "(QI) Start and end time of administration"
      },
      {
        "id" : "MedicationAdministration.request",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.request",
        "short" : "(QI) Request administration performed against",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.dosage",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.dosage",
        "short" : "(QI) Details of how medication was taken",
        "definition" : "Describes the medication dosage information details e.g. dose, rate, site, route, etc.",
        "mustSupport" : false
      },
      {
        "id" : "MedicationAdministration.dosage.route",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.dosage.route",
        "short" : "(QI) Path of substance into body",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/route-codes"
        }
      },
      {
        "id" : "MedicationAdministration.dosage.dose",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.dosage.dose",
        "short" : "(QI) Amount of medication per dose"
      }
    ]
  }
}

```
