# QI-Core Key Element Extension - QI-Core Implementation Guide v8.0.0-ballot

## Extension: QI-Core Key Element Extension 

**This extension is only used in the QI-Core Implementation Guide's Profile StructureDefinition elements.** It flags elements that the quality improvement community has identified as significant to express the full intent of measures or decision support artifacts. See the [MustSupport Flag](index.md#mustsupport-flag) section in this IG for more information.

**Context of Use**

**Usage info**

**Usages:**

* Examples for this Extension: [QICoreAdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICoreAllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md), [QICoreBodyStructure](StructureDefinition-qicore-bodystructure.md), [QICoreCarePlan](StructureDefinition-qicore-careplan.md)...Show 46 more,[QICoreCareTeam](StructureDefinition-qicore-careteam.md),[QICoreClaim](StructureDefinition-qicore-claim.md),[QICoreClaimResponse](StructureDefinition-qicore-claimresponse.md),[QICoreCommunication](StructureDefinition-qicore-communication.md),[QICoreCommunicationDone](StructureDefinition-qicore-communicationdone.md),[QICoreCommunicationNotDone](StructureDefinition-qicore-communicationnotdone.md),[QICoreCommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICoreConditionEncounterDiagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md),[QICoreConditionProblemsHealthConcerns](StructureDefinition-qicore-condition-problems-health-concerns.md),[QICoreDevice](StructureDefinition-qicore-device.md),[QICoreDeviceProhibited](StructureDefinition-qicore-deviceprohibited.md),[QICoreDeviceRequest](StructureDefinition-qicore-devicerequest.md),[QICoreDeviceRequested](StructureDefinition-qicore-devicerequested.md),[QICoreDeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md),[QICoreDiagnosticReportLab](StructureDefinition-qicore-diagnosticreport-lab.md),[QICoreDiagnosticReportNote](StructureDefinition-qicore-diagnosticreport-note.md),[QICoreEncounter](StructureDefinition-qicore-encounter.md),[QICoreFamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md),[QICoreFlag](StructureDefinition-qicore-flag.md),[QICoreGoal](StructureDefinition-qicore-goal.md),[QICoreImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICoreImmunization](StructureDefinition-qicore-immunization.md),[QICoreImmunizationDone](StructureDefinition-qicore-immunizationdone.md),[QICoreImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md),[QICoreImmunizationNotDone](StructureDefinition-qicore-immunizationnotdone.md),[QICoreImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md),[QICoreLocation](StructureDefinition-qicore-location.md),[QICoreMedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICoreMedicationAdministrationDone](StructureDefinition-qicore-medicationadministrationdone.md),[QICoreMedicationAdministrationNotDone](StructureDefinition-qicore-medicationadministrationnotdone.md),[QICoreMedicationDispense](StructureDefinition-qicore-medicationdispense.md),[QICoreMedicationDispenseDeclined](StructureDefinition-qicore-medicationdispensedeclined.md),[QICoreMedicationDispenseDone](StructureDefinition-qicore-medicationdispensedone.md),[QICoreMedicationProhibited](StructureDefinition-qicore-medicationprohibited.md),[QICoreMedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md),[QICoreMedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICoreNonPatientObservation](StructureDefinition-qicore-nonpatient-observation.md),[QICoreNutritionOrder](StructureDefinition-qicore-nutritionorder.md),[QICoreObservationClinicalResult](StructureDefinition-qicore-observation-clinical-result.md),[QICoreLaboratoryResultObservation](StructureDefinition-qicore-observation-lab.md),[QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICoreOrganization](StructureDefinition-qicore-organization.md),[QICorePatient](StructureDefinition-qicore-patient.md),[QICorePractitioner](StructureDefinition-qicore-practitioner.md)and[QICorePractitionerRole](StructureDefinition-qicore-practitionerrole.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-keyelement)

### Formal Views of Extension Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-keyelement.csv), [Excel](../StructureDefinition-qicore-keyelement.xlsx), [Schematron](../StructureDefinition-qicore-keyelement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-keyelement",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
  "version" : "8.0.0-ballot",
  "name" : "QICORE_KeyElement",
  "title" : "QI-Core Key Element Extension",
  "status" : "active",
  "date" : "2023-04-03",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "**This extension is only used in the QI-Core Implementation Guide's Profile StructureDefinition elements.** It flags elements that the quality improvement community has identified as significant to express the full intent of measures or decision support artifacts. See the [MustSupport Flag](index.html#mustsupport-flag) section in this IG for more information.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ElementDefinition"
    },
    {
      "type" : "element",
      "expression" : "ElementDefinition.type.targetProfile"
    },
    {
      "type" : "element",
      "expression" : "ElementDefinition.type"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "QI-Core Key Element Flag: ONLY USED FOR QI-Core Profile StructureDefinitions",
        "definition" : "**This extension is only used on QI-Core Profile StructureDefinition elements**. It flags elements that are QI-Core Key Elements.",
        "min" : 0,
        "max" : "1",
        "isModifier" : false,
        "mapping" : [
          {
            "identity" : "v2",
            "map" : "No v2 equivalent"
          },
          {
            "identity" : "rim",
            "map" : "No RIM equivalent"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
