# QICore FamilyMemberHistory - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore FamilyMemberHistory 

 
Profile of Family Member History for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* relationship: (QI) Relationship to the subject
* deceased[x]: (QI) Dead? How old/when?
* age[x]: (QI) (approximate) age
* patient: (QI) Patient history is about
* date: (QI) When history was recorded or last updated

**Primary code path:**FamilyMemberHistory.condition.code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Father Died of Heart Attack Example](FamilyMemberHistory-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md)
* Examples for this Profile: [FamilyMemberHistory/example](FamilyMemberHistory-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-familymemberhistory)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-familymemberhistory.csv), [Excel](../StructureDefinition-qicore-familymemberhistory.xlsx), [Schematron](../StructureDefinition-qicore-familymemberhistory.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-familymemberhistory",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "FamilyMemberHistory.condition.code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Location"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-familymemberhistory",
  "version" : "8.0.0-ballot",
  "name" : "QICoreFamilyMemberHistory",
  "title" : "QICore FamilyMemberHistory",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Family Member History for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "FamilyMemberHistory",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "FamilyMemberHistory",
        "path" : "FamilyMemberHistory"
      },
      {
        "id" : "FamilyMemberHistory.patient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.patient",
        "short" : "(QI) Patient history is about",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "FamilyMemberHistory.date",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.date",
        "short" : "(QI) When history was recorded or last updated"
      },
      {
        "id" : "FamilyMemberHistory.relationship",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.relationship",
        "short" : "(QI) Relationship to the subject",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-FamilyMember"
        }
      },
      {
        "id" : "FamilyMemberHistory.age[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.age[x]",
        "short" : "(QI) (approximate) age"
      },
      {
        "id" : "FamilyMemberHistory.deceased[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.deceased[x]",
        "short" : "(QI) Dead? How old/when?"
      },
      {
        "id" : "FamilyMemberHistory.condition",
        "path" : "FamilyMemberHistory.condition",
        "mustSupport" : false
      },
      {
        "id" : "FamilyMemberHistory.condition.extension:condition-abatement",
        "path" : "FamilyMemberHistory.condition.extension",
        "sliceName" : "condition-abatement",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement|5.2.0-ballot"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "FamilyMemberHistory.condition.extension:condition-severity",
        "path" : "FamilyMemberHistory.condition.extension",
        "sliceName" : "condition-severity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/familymemberhistory-severity|5.2.0-ballot"
            ]
          }
        ],
        "mustSupport" : false,
        "binding" : {
          "strength" : "preferred",
          "description" : "Valueset to identify the severity of the problem",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-severity"
        }
      },
      {
        "id" : "FamilyMemberHistory.condition.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "FamilyMemberHistory.condition.code",
        "short" : "(QI) Condition suffered by relation",
        "binding" : {
          "strength" : "extensible",
          "description" : "Identification of the Condition or diagnosis.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "FamilyMemberHistory.condition.onset[x]",
        "path" : "FamilyMemberHistory.condition.onset[x]",
        "mustSupport" : false
      }
    ]
  }
}

```
