# QICore DiagnosticReport Profile for Report and Note Exchange - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore DiagnosticReport Profile for Report and Note Exchange 

 
Profile of DiagnosticReport for Note exchange for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) The subject of the report - usually, but not always, the patient
* status: (QI)registered | partial | preliminary | final +
* category: (QI) Service Category
* code: (QI) QI-Core Report Code

**QI Elements:**
* effective[x]: (QI) Diagnostically relevant time (typically the time of the procedure)
* result: (QI) Observations
* imagingStudy: (QI) Reference to full details of imaging associated with the diagnostic report
* issued: (QI) DateTime this version was made
* media: (QI) Key images associated with this report
* encounter: (QI) Health care event when test ordered
* performer: (QI) Responsible Diagnostic Service

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Radiology Diagnostic Report Example](DiagnosticReport-note-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md), [QICore Procedure](StructureDefinition-qicore-procedure.md) and [QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)
* Examples for this Profile: [DiagnosticReport/note-example](DiagnosticReport-note-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-diagnosticreport-note)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-diagnosticreport-note.csv), [Excel](../StructureDefinition-qicore-diagnosticreport-note.xlsx), [Schematron](../StructureDefinition-qicore-diagnosticreport-note.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-diagnosticreport-note",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "DiagnosticReportNote"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-note",
  "version" : "8.0.0-ballot",
  "name" : "QICoreDiagnosticReportNote",
  "title" : "QICore DiagnosticReport Profile for Report and Note Exchange",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-01",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of DiagnosticReport for Note exchange for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport"
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "short" : "(QI)registered | partial | preliminary | final +",
        "definition" : "The status of the diagnostic report.",
        "requirements" : "Diagnostic services routinely issue provisional/incomplete reports, and sometimes withdraw previously released reports.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.status",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "condition" : ["us-core-8", "us-core-9"],
        "mustSupport" : true,
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid",
        "isSummary" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status"
        },
        "mapping" : [
          {
            "identity" : "workflow",
            "map" : "Event.status"
          },
          {
            "identity" : "w5",
            "map" : "FiveWs.status"
          },
          {
            "identity" : "v2",
            "map" : "OBR-25 (not 1:1 mapping)"
          },
          {
            "identity" : "rim",
            "map" : "statusCode  Note: final and amended are distinguished by whether observation is the subject of a ControlAct event of type \"revise\""
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) Service Category",
        "min" : 1
      },
      {
        "id" : "DiagnosticReport.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.code",
        "short" : "(QI) QI-Core Report Code",
        "definition" : "The test, panel, report, or note that was ordered.",
        "comment" : "The typical patterns for codes are:  1)  a LOINC code either as a translation from a \"local\" code or as a primary code, or 2)  a local code only if no suitable LOINC exists,  or 3)  both the local and the LOINC translation.   Systems SHALL be capable of sending the local code if one exists.",
        "alias" : ["Type"],
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.code",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "LOINC codes",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-diagnosticreport-report-and-note-codes"
        }
      },
      {
        "id" : "DiagnosticReport.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.subject",
        "short" : "(QI) The subject of the report - usually, but not always, the patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.encounter",
        "short" : "(QI) Health care event when test ordered",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.effective[x]",
        "short" : "(QI) Diagnostically relevant time (typically the time of the procedure)",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.effective[x]",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.issued",
        "short" : "(QI) DateTime this version was made"
      },
      {
        "id" : "DiagnosticReport.performer",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.performer",
        "short" : "(QI) Responsible Diagnostic Service",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.result",
        "short" : "(QI) Observations",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation-lab",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation-clinical-result"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.imagingStudy",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.imagingStudy",
        "short" : "(QI) Reference to full details of imaging associated with the diagnostic report",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-imagingstudy"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.media",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.media",
        "short" : "(QI) Key images associated with this report"
      }
    ]
  }
}

```
