# QICore DiagnosticReport Profile for Laboratory Results Reporting - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore DiagnosticReport Profile for Laboratory Results Reporting 

 
Profile of DiagnosticReport for laboratory results for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) The subject of the report - usually, but not always, the patient
* status: (QI)registered | partial | preliminary | final +
* code: (QI) US Core Laboratory Report Order Code
* category: (QI) Service category
* category(LaboratorySlice): (QI) Service category

**QI Elements:**
* effective[x]: (QI) Diagnostically relevant time (typically the time of specimen collection)
* result: (QI) Observations
* basedOn: (QI) What was requested
* performer: (QI) Responsible Diagnostic Service

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Blood Panel Example](DiagnosticReport-example.md) |

 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-diagnosticreport-lab)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-diagnosticreport-lab.csv), [Excel](../StructureDefinition-qicore-diagnosticreport-lab.xlsx), [Schematron](../StructureDefinition-qicore-diagnosticreport-lab.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-diagnosticreport-lab",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "DiagnosticReportLab"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-lab",
  "version" : "8.0.0-ballot",
  "name" : "QICoreDiagnosticReportLab",
  "title" : "QICore DiagnosticReport Profile for Laboratory Results Reporting",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-01",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of DiagnosticReport for laboratory results for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DiagnosticReport",
        "path" : "DiagnosticReport"
      },
      {
        "id" : "DiagnosticReport.basedOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.basedOn",
        "short" : "(QI) What was requested",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careplan",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationrecommendation",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-nutritionorder",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "DiagnosticReport.status",
        "path" : "DiagnosticReport.status",
        "short" : "(QI)registered | partial | preliminary | final +",
        "definition" : "The status of the diagnostic report.",
        "requirements" : "Diagnostic services routinely issue provisional/incomplete reports, and sometimes withdraw previously released reports.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.status",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "condition" : ["us-core-8", "us-core-9"],
        "mustSupport" : true,
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid",
        "isSummary" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-report-status"
        },
        "mapping" : [
          {
            "identity" : "workflow",
            "map" : "Event.status"
          },
          {
            "identity" : "w5",
            "map" : "FiveWs.status"
          },
          {
            "identity" : "v2",
            "map" : "OBR-25 (not 1:1 mapping)"
          },
          {
            "identity" : "rim",
            "map" : "statusCode  Note: final and amended are distinguished by whether observation is the subject of a ControlAct event of type \"revise\""
          }
        ]
      },
      {
        "id" : "DiagnosticReport.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) Service category",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosticServiceSection"
            }
          ],
          "strength" : "preferred",
          "description" : "Codes for diagnostic service sections.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "DiagnosticReport.category:LaboratorySlice",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.category",
        "sliceName" : "LaboratorySlice",
        "short" : "(QI) Service category",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
              "code" : "LAB"
            }
          ]
        },
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosticServiceSection"
            }
          ],
          "strength" : "preferred",
          "description" : "Codes for diagnostic service sections.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/diagnostic-service-sections"
        }
      },
      {
        "id" : "DiagnosticReport.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.code",
        "short" : "(QI) US Core Laboratory Report Order Code",
        "definition" : "The test, panel or battery that was ordered.",
        "comment" : "UsageNote= The typical patterns for codes are:  1)  a LOINC code either as a  translation from a \"local\" code or as a primary code, or 2)  a local code only if no suitable LOINC exists,  or 3)  both the local and the LOINC translation.   Systems SHALL be capable of sending the local code if one exists.",
        "alias" : ["Type"],
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.code",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "LOINC codes",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-laboratory-test-codes"
        }
      },
      {
        "id" : "DiagnosticReport.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.subject",
        "short" : "(QI) The subject of the report - usually, but not always, the patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.encounter",
        "path" : "DiagnosticReport.encounter",
        "short" : "(QI) Encounter associated with DiagnosticReport",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.effective[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.effective[x]",
        "short" : "(QI) Diagnostically relevant time (typically the time of specimen collection)",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "DiagnosticReport.issued",
        "path" : "DiagnosticReport.issued",
        "short" : "(QI) DateTime this version was made",
        "definition" : "The date and time that this version of the report was made available to providers, typically after the report was reviewed and verified.",
        "comment" : "May be different from the update time of the resource itself, because that is the status of the record (potentially a secondary copy), not the actual release time of the report.",
        "requirements" : "Clinicians need to be able to check the date that the report was released.",
        "alias" : ["Date published", "Date Issued", "Date Verified"],
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DiagnosticReport.issued",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "instant"
          }
        ],
        "condition" : ["us-core-9"],
        "mustSupport" : true,
        "isModifier" : false,
        "isSummary" : true,
        "mapping" : [
          {
            "identity" : "w5",
            "map" : "FiveWs.recorded"
          },
          {
            "identity" : "v2",
            "map" : "OBR-22"
          },
          {
            "identity" : "rim",
            "map" : "participation[typeCode=VRF or AUT].time"
          }
        ]
      },
      {
        "id" : "DiagnosticReport.performer",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.performer",
        "short" : "(QI) Responsible Diagnostic Service",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "DiagnosticReport.result",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DiagnosticReport.result",
        "short" : "(QI) Observations",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation-lab"
            ]
          }
        ]
      }
    ]
  }
}

```
