# QICore CommunicationDone - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore CommunicationDone 

 
Positive profile of Communication for decision support/quality metrics. Indicates that the communication was performed (as opposed to the not done profile). 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* topic.extension(codeOptions): (QI) Url of a value set of candidate topics
* status: (QI) preparation | in-progress | on-hold | stopped | completed
* sender: (QI) Message sender
* sent: (QI) When sent
* topic: (QI) Description of the purpose/content
* subject: (QI) Focus of message
* received: (QI) When received
* recipient: (QI) Message recipient

**Primary code path:**topic

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Communication profile defines the conformance expectations for a Communication event, regardless of whether it is a positive or negative statement.

The CommunicationDone and CommunicationNotDone profiles represent the positive and negative statements for a communication event.

To create an expression indicating existence of a communication, use the profile [QICoreCommunicationDone](StructureDefinition-qicore-communicationdone.md); to specifically request information that a communication intentionally did not occur for a medical, patient or system reason, use the profile [QICoreCommunicationNotDone](StructureDefinition-qicore-communicationnotdone.md).

```
define CommunicationDone:
  [CommunicationDone]

```

Note that the statuses indicating positive intent are implied by the use of the CommunicationDone profile in the above expression.

See the [patterns](patterns.md) page for implementation and usage patterns.

### Examples

 

| |
| :--- |
| [Written Alert Example](Communication-done-example.md) |

 

**Usages:**

* Examples for this Profile: [Communication/done-example](Communication-done-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-communicationdone)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-communicationdone.csv), [Excel](../StructureDefinition-qicore-communicationdone.xlsx), [Schematron](../StructureDefinition-qicore-communicationdone.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-communicationdone",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "topic"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "CommunicationDone"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communicationdone",
  "version" : "8.0.0-ballot",
  "name" : "QICoreCommunicationDone",
  "title" : "QICore CommunicationDone",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-01",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Positive profile of Communication for decision support/quality metrics. Indicates that the communication was performed (as opposed to the not done profile).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Communication",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Communication",
        "path" : "Communication",
        "mustSupport" : false
      },
      {
        "id" : "Communication.status",
        "path" : "Communication.status",
        "short" : "(QI) preparation | in-progress | on-hold | stopped | completed",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-event-status"
        }
      }
    ]
  }
}

```
