# QICore AdverseEvent - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore AdverseEvent 

 
Actual or potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* category: (QI) product-problem | product-quality | product-use-error | wrong-dose | incorrect-prescribing-information | wrong-technique | wrong-route-of-administration | wrong-rate | wrong-duration | wrong-time | expired-drug | medical-device-use-error | problem-different-manufacturer | unsafe-physical-environment
* severity: (QI) mild | moderate | severe
* resultingCondition: (QI) Effect on the subject due to this event
* event: (QI) Type of the event itself in relation to the subject
* encounter: (QI) Encounter created as part of
* date: (QI) When the event occurred
* seriousness: (QI) Seriousness of the event
* recordedDate: (QI) When the event was recorded
* subject: (QI) Subject impacted by event
* actuality: (QI) actual | potential

**Primary code path:**event

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Mild Rash Example](AdverseEvent-example.md) |

 

**Usages:**

* Examples for this Profile: [AdverseEvent/example](AdverseEvent-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-adverseevent)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-adverseevent.csv), [Excel](../StructureDefinition-qicore-adverseevent.xlsx), [Schematron](../StructureDefinition-qicore-adverseevent.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-adverseevent",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "event"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "AdverseEvent"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-adverseevent",
  "version" : "8.0.0-ballot",
  "name" : "QICoreAdverseEvent",
  "title" : "QICore AdverseEvent",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Actual or potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AdverseEvent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/AdverseEvent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AdverseEvent",
        "path" : "AdverseEvent"
      },
      {
        "id" : "AdverseEvent.actuality",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.actuality",
        "short" : "(QI) actual | potential"
      },
      {
        "id" : "AdverseEvent.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.category",
        "short" : "(QI) product-problem | product-quality | product-use-error | wrong-dose | incorrect-prescribing-information | wrong-technique | wrong-route-of-administration | wrong-rate | wrong-duration | wrong-time | expired-drug | medical-device-use-error | problem-different-manufacturer | unsafe-physical-environment"
      },
      {
        "id" : "AdverseEvent.event",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.event",
        "short" : "(QI) Type of the event itself in relation to the subject",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "description" : "Detailed type of event.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/adverse-event-type"
        }
      },
      {
        "id" : "AdverseEvent.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.subject",
        "short" : "(QI) Subject impacted by event",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.encounter",
        "short" : "(QI) Encounter created as part of",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.date",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.date",
        "short" : "(QI) When the event occurred",
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.recordedDate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.recordedDate",
        "short" : "(QI) When the event was recorded"
      },
      {
        "id" : "AdverseEvent.resultingCondition",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.resultingCondition",
        "short" : "(QI) Effect on the subject due to this event",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.location",
        "path" : "AdverseEvent.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.seriousness",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.seriousness",
        "short" : "(QI) Seriousness of the event",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "example",
          "description" : "Overall seriousness of this event for the patient.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/adverse-event-seriousness"
        }
      },
      {
        "id" : "AdverseEvent.severity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.severity",
        "short" : "(QI) mild | moderate | severe",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "The severity of the adverse event itself, in direct relation to the subject.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/adverse-event-severity"
        }
      },
      {
        "id" : "AdverseEvent.recorder",
        "path" : "AdverseEvent.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.contributor",
        "path" : "AdverseEvent.contributor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.suspectEntity",
        "path" : "AdverseEvent.suspectEntity",
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.suspectEntity.instance",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "AdverseEvent.suspectEntity.instance",
        "short" : "(QI) Refers to the specific entity that caused the adverse event",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-substance",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministration",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationstatement",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device"
            ]
          }
        ]
      },
      {
        "id" : "AdverseEvent.suspectEntity.causality",
        "path" : "AdverseEvent.suspectEntity.causality",
        "min" : 0,
        "max" : "1",
        "mustSupport" : false
      },
      {
        "id" : "AdverseEvent.subjectMedicalHistory",
        "path" : "AdverseEvent.subjectMedicalHistory",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-allergyintolerance",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-familymemberhistory",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis"
            ]
          }
        ],
        "mustSupport" : false
      }
    ]
  }
}

```
