# ServiceProhibited with value set example - QI-Core Implementation Guide v8.0.0-ballot

## Example ServiceRequest: ServiceProhibited with value set example

Language: en

Profile: [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md)

**status**: Completed

**intent**: Order

**category**: Surgical Procedure

**priority**: Urgent

**doNotPerform**: true

**code**: Value Set: Intermittent pneumatic compression devices (IPC) (value set: [Intermittent pneumatic compression devices](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.214/expansion))

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-04-05

**authoredOn**: 2013-04-04

**reasonCode**: Procedure discontinued (situation)

**bodySite**: Appendix structure



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-serviceprohibited"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387713003",
          "display" : "Surgical Procedure"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "doNotPerform" : true,
  "code" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.214"
      }
    ],
    "text" : "Value Set: Intermittent pneumatic compression devices (IPC)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-04-05",
  "authoredOn" : "2013-04-04",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "416406003",
          "display" : "Procedure discontinued (situation)"
        }
      ]
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66754008",
          "display" : "Appendix structure"
        }
      ]
    }
  ]
}

```
