# ServiceRequest Myringotomy Procedure example - QI-Core Implementation Guide v8.0.0-ballot

## Example ServiceRequest: ServiceRequest Myringotomy Procedure example

Language: en

Profile: [QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)

**status**: On Hold

**intent**: Order

**category**: Surgical Procedure

**priority**: Routine

**code**: Myringotomy and insertion of short-term tympanic ventilation tube (procedure)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2014-02-13 --> 2014-02-13

**asNeeded**: true

**authoredOn**: 2014-02-14

**performerType**: Pediatric otolaryngology

**reasonCode**: Otitis media



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "myringotomy-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest"
    ]
  },
  "language" : "en",
  "status" : "on-hold",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387713003",
          "display" : "Surgical Procedure"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "172676009",
        "display" : "Myringotomy and insertion of short-term tympanic ventilation tube (procedure)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrencePeriod" : {
    "start" : "2014-02-13",
    "end" : "2014-02-13"
  },
  "asNeededBoolean" : true,
  "authoredOn" : "2014-02-14",
  "performerType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "417887005",
        "display" : "Pediatric otolaryngology"
      }
    ]
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "65363002",
          "display" : "Otitis media"
        }
      ]
    }
  ]
}

```
