# PractitionerRole example - QI-Core Implementation Guide v8.0.0-ballot

## Example PractitionerRole: PractitionerRole example

Language: en

Profile: [QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md)

**identifier**: `http://www.acme.org/practitionerroles`/31 (use: temp, )

**active**: true

**period**: 1995 --> (ongoing)

**practitioner**: [Dr Adam Careful](Practitioner-example.md)

**organization**: [Organization Health Level Seven International](Organization-example.md)

**code**: Clinic/Center

**specialty**: Dentist

**location**: [Location South Wing, second floor](Location-example.md)

**telecom**: ph: 801-123-4567



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "use" : "temp",
      "system" : "http://www.acme.org/practitionerroles",
      "value" : "31"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "1995"
  },
  "practitioner" : {
    "reference" : "Practitioner/example",
    "display" : "Dr Adam Careful"
  },
  "organization" : {
    "reference" : "Organization/example"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://nucc.org/provider-taxonomy",
          "code" : "261Q00000X",
          "display" : "Clinic/Center"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://nucc.org/provider-taxonomy",
          "code" : "122300000X",
          "display" : "Dentist"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/example"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "801-123-4567"
    }
  ]
}

```
