# Practitioner example - QI-Core Implementation Guide v8.0.0-ballot

## Example Practitioner: Practitioner example

Language: en

Profile: [QICore Practitioner](StructureDefinition-qicore-practitioner.md)

**identifier**: [United States Employer Identification Number](http://terminology.hl7.org/6.5.0/NamingSystem-USEIN.html)/Practitioner-23 (use: temp, )

**active**: true

**name**: Adam Careful 

**address**: 534 Erewhon St PleasantVille UT 84414 (home)

### Qualifications

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Identifier** | **Code** | **Period** | **Issuer** |
| * | `http://example.org/UniversityIdentifier`/12345 | Bachelor of Science | 1995 --> (ongoing) | Example University |



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "use" : "temp",
      "system" : "urn:oid:2.16.840.1.113883.4.4",
      "value" : "Practitioner-23"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Careful",
      "given" : ["Adam"],
      "prefix" : ["Dr"]
    }
  ],
  "address" : [
    {
      "use" : "home",
      "line" : ["534 Erewhon St"],
      "city" : "PleasantVille",
      "state" : "UT",
      "postalCode" : "84414"
    }
  ],
  "qualification" : [
    {
      "identifier" : [
        {
          "system" : "http://example.org/UniversityIdentifier",
          "value" : "12345"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0360",
            "code" : "BS",
            "display" : "Bachelor of Science"
          }
        ],
        "text" : "Bachelor of Science"
      },
      "period" : {
        "start" : "1995"
      },
      "issuer" : {
        "display" : "Example University"
      }
    }
  ]
}

```
