# Infant patient example - QI-Core Implementation Guide v8.0.0-ballot

## Example Patient: Infant patient example

Language: en

Profile: [QICore Patient](StructureDefinition-qicore-patient.md)

Infant Example Male, DoB: 2020-06-02 ( Medical Record Number: 1032703 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Contact Detail | * ph: 555-555-5555(Home)
* 49 Meadow St Mounds OK 74047 US 
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "infant-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org",
      "value" : "1032703"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Example",
      "given" : ["Infant"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "birthDate" : "2020-06-02",
  "address" : [
    {
      "line" : ["49 Meadow St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US"
    }
  ]
}

```
