# Patient example - QI-Core Implementation Guide v8.0.0-ballot

## Example Patient: Patient example

Language: en

Profile: [QICore Patient](StructureDefinition-qicore-patient.md)

Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Active: | true | Deceased: | false |
| Contact Detail | * ph: (03) 5555 6473(Work)
* ph: (03) 3410 5613(Mobile)
* ph: (03) 5555 8834(Old)
* 534 Erewhon St PeasantVille, Utah 84414(home)
 | | |
| Next-of-Kin: | * Bénédicte du Marché (Female)
* 534 Erewhon St PleasantVille VT 3999 (home)
* [+33 (237) 998327](tel:+33(237)998327)
* Valid Period:2012 --> (ongoing)
 | | |
| Links: | * Managing Organization: [Organization Health Level Seven International](Organization-example.md)
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR"
          }
        ]
      },
      "system" : "http://example.org/patient/identifiers",
      "value" : "12345",
      "period" : {
        "start" : "2001-05-06"
      },
      "assigner" : {
        "display" : "Acme Healthcare"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "family" : "Chalmers",
      "given" : ["Peter", "James"]
    },
    {
      "use" : "usual",
      "family" : "Chalmers",
      "given" : ["Jim"]
    },
    {
      "use" : "maiden",
      "family" : "Windsor",
      "given" : ["Peter", "James"],
      "period" : {
        "end" : "2002"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5555 6473",
      "use" : "work",
      "rank" : 1
    },
    {
      "system" : "phone",
      "value" : "(03) 3410 5613",
      "use" : "mobile",
      "rank" : 2
    },
    {
      "system" : "phone",
      "value" : "(03) 5555 8834",
      "use" : "old",
      "period" : {
        "end" : "2014"
      }
    }
  ],
  "gender" : "male",
  "birthDate" : "1974-12-25",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthTime",
        "valueDateTime" : "1974-12-25T14:35:45-05:00"
      }
    ]
  },
  "deceasedBoolean" : false,
  "address" : [
    {
      "use" : "home",
      "type" : "both",
      "text" : "534 Erewhon St PeasantVille, Utah 84414",
      "line" : ["534 Erewhon St"],
      "city" : "PleasantVille",
      "district" : "Rainbow",
      "state" : "UT",
      "postalCode" : "84414",
      "period" : {
        "start" : "1974-12-25"
      }
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N"
            }
          ]
        }
      ],
      "name" : {
        "family" : "du Marché",
        "_family" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix",
              "valueString" : "VV"
            }
          ]
        },
        "given" : ["Bénédicte"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+33 (237) 998327"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "both",
        "line" : ["534 Erewhon St"],
        "city" : "PleasantVille",
        "district" : "Rainbow",
        "state" : "VT",
        "postalCode" : "3999",
        "period" : {
          "start" : "1974-12-25"
        }
      },
      "gender" : "female",
      "period" : {
        "start" : "2012"
      }
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/example"
  }
}

```
