# ODH Observation example - QI-Core Implementation Guide v8.0.0-ballot

## Example Observation: ODH Observation example

Language: en

Profile: [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)

**status**: Final

**category**: Social History

**code**: History of Usual Occupation

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**effective**: 2020-04-09 06:30:00+0500 --> 2023-10-22 08:30:10+0500

**performer**: [Practitioner](Practitioner-example.md)

**value**: Radiology Technician (Radiology Tech) [Radiologic Technicians]



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "example-odh",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "21843-8",
        "display" : "History of Usual Occupation"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "effectivePeriod" : {
    "start" : "2020-04-09T06:30:00+05:00",
    "end" : "2023-10-22T08:30:10+05:00"
  },
  "performer" : [
    {
      "reference" : "Practitioner/example",
      "display" : "Practitioner"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH",
        "code" : "29-2099.06.034077",
        "display" : "Radiology Technician (Radiology Tech) [Radiologic Technicians]"
      }
    ]
  }
}

```
