# Hospital Bed Availability (physical object) Observation Example - QI-Core Implementation Guide v8.0.0-ballot

## Example Observation: Hospital Bed Availability (physical object) Observation Example

Language: en

Profile: [QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md)

**status**: Final

**category**: Device (physical object)

**code**: Hospital bed, device (physical object)

**subject**: [Hospital Bed](Device-example.md)

**effective**: 2023-07-07

**performer**: [Hendricks Country Hospital](Organization-example1.md)

**value**: Equipment available (finding)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "example-nonpatient-hospital-bed",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-nonpatient-observation"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "49062001",
          "display" : "Device (physical object)"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "91537007",
        "display" : "Hospital bed, device (physical object)"
      }
    ]
  },
  "subject" : {
    "reference" : "Device/example",
    "display" : "Hospital Bed"
  },
  "effectiveDateTime" : "2023-07-07",
  "performer" : [
    {
      "reference" : "Organization/example1",
      "display" : "Hendricks Country Hospital"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "735333005",
        "display" : "Equipment available (finding)"
      }
    ]
  }
}

```
