# Condition Problems Health Concerns example - QI-Core Implementation Guide v8.0.0-ballot

## Example Condition: Condition Problems Health Concerns example

Language: en

Profile: [QICore Condition Problems Health Concerns](StructureDefinition-qicore-condition-problems-health-concerns.md)

**Condition Asserted Date**: 2007-12-14

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Health Concern

**code**: Fear of becoming fat

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**onset**: 2007-12-14

**recordedDate**: 2007-12-14 07:15:07-0800



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "health-concern-example",
  "meta" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-name",
        "valueString" : "Health Concern Example"
      },
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/instance-description",
        "valueMarkdown" : "This example of a QI-Core Condition Problems and Health Concerns Profile illustrates its use to capture information about a patient's health concern."
      }
    ],
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/condition-assertedDate",
      "valueDateTime" : "2007-12-14"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/condition-category",
          "code" : "health-concern",
          "display" : "Health Concern"
        }
      ],
      "text" : "Health Concern"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "247824007",
        "display" : "Fear of becoming fat"
      }
    ],
    "text" : "Fear of becoming fat"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "onsetDateTime" : "2007-12-14",
  "recordedDate" : "2007-12-14T07:15:07-08:00"
}

```
