# Positive Task Status - QI-Core Implementation Guide v8.0.0-ballot

## ValueSet: Positive Task Status 

 
This value set defines the set of codes that indicate a positive task status 

 **References** 

* [QICore Task Done](StructureDefinition-qicore-taskdone.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-task-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-task-status",
  "version" : "8.0.0-ballot",
  "name" : "PositiveTaskStatus",
  "title" : "Positive Task Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive task status",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of task statuses in FHIR that indicate a positive status.",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/task-status",
        "concept" : [
          {
            "code" : "draft",
            "display" : "Draft"
          },
          {
            "code" : "requested",
            "display" : "Requested"
          },
          {
            "code" : "received",
            "display" : "Received"
          },
          {
            "code" : "accepted",
            "display" : "Accepted"
          },
          {
            "code" : "ready",
            "display" : "Ready"
          },
          {
            "code" : "in-progress",
            "display" : "In Progress"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          }
        ]
      }
    ]
  }
}

```
