# Positive Request Status - QI-Core Implementation Guide v8.0.0-ballot

## ValueSet: Positive Request Status 

 
This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered). 

 **References** 

* [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md)
* [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-request-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-request-status",
  "version" : "8.0.0-ballot",
  "name" : "PositiveRequestStatus",
  "title" : "Positive Request Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of request statuses in FHIR that indicate a positive status (i.e. all the codes from the http://hl7.org/fhir/request-status code system that indicate an activity is proposed, planned, or ordered).",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/request-status",
        "concept" : [
          {
            "code" : "draft",
            "display" : "Draft"
          },
          {
            "code" : "active",
            "display" : "Active"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "revoked",
            "display" : "Revoked"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          }
        ]
      }
    ]
  }
}

```
