# Positive MedicationDispense Status - QI-Core Implementation Guide v8.0.0-ballot

## ValueSet: Positive MedicationDispense Status 

 
This value set defines the set of codes that indicate a positive medication dispense status (i.e. codes that indicate at least some medication was dispensed) 

 **References** 

* [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-medicationdispense-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medicationdispense-status",
  "version" : "8.0.0-ballot",
  "name" : "PositiveMedicationDispenseStatus",
  "title" : "Positive MedicationDispense Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive medication dispense status (i.e. codes that indicate at least some medication was dispensed)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of medication dispense statuses in FHIR that do indicate a positive status (i.e. all the codes from the http://terminology.hl7.org/CodeSystem/medicationdispense-status code system that indicate at least some medication was dispensed).",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/medicationdispense-status",
        "concept" : [
          {
            "code" : "preparation",
            "display" : "Preparation"
          },
          {
            "code" : "in-progress",
            "display" : "In Progress"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          },
          {
            "code" : "stopped",
            "display" : "Stopped"
          }
        ]
      }
    ]
  }
}

```
