# TaskRejected example rejecting a proposal using a value set - QI-Core Implementation Guide v8.0.0-ballot

## Example Task: TaskRejected example rejecting a proposal using a value set

Language: en

Profile: [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)

**identifier**: `http://www.acme.org/tasks`/19009

**status**: Rejected

**statusReason**: Patient noncompliance - general (situation)

**intent**: proposal

**code**: Fulfill the focal request

**focus**: [ServiceRequest](ServiceRequest-proposal-example.md)

**for**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**executionPeriod**: 2018-06-11 --> 2018-06-11



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "rejected-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://www.acme.org/tasks",
      "value" : "19009"
    }
  ],
  "status" : "rejected",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "275936005",
        "display" : "Patient noncompliance - general (situation)"
      }
    ]
  },
  "intent" : "proposal",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill",
        "display" : "Fulfill the focal request"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/proposal-example"
  },
  "for" : {
    "reference" : "Patient/example"
  },
  "executionPeriod" : {
    "start" : "2018-06-11",
    "end" : "2018-06-11"
  }
}

```
