# QICore Service Prohibited - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore Service Prohibited 

 
Negation profile of ServiceRequest for decision support/quality metrics. Indicates a request not to provide a service 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code: (QI) What is being requested/ordered
* subject: (QI) Individual or Entity the service is ordered for
* authoredOn: (QI) Date request signed
* status: (QI) draft | active | on-hold | completed

**QI Elements:**
* code.extension(codeOptions): (QI) Url of a value set of candidate services
* reasonCode: (QI) Explanation/Justification for procedure or service
* occurrence[x]: (QI) When service should occur
* doNotPerform: (QI) True if service/procedure should not be performed
* reasonReference: (QI) Explanation/Justification for service or service

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

### Guidance

 Reference Guidance for use of the Service Prohibited profile can be found[here.](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-servicerequest.html#mandatory-and-must-support-data-elements)
* See the [Social Determinants of Health (SDOH)](https://hl7.org/fhir/us/core/sdoh.html) Guidance Page for more information when exchanging Social Determinants of Health (SDOH) Service Requests.
* The `ServiceRequest.category` binding must support at a minimum the [US Core ServiceRequest Category Codes](http://hl7.org/fhir/us/core/STU8/ValueSet-us-core-servicerequest-category.html). However, this valueset can be treated as [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) and other category codes can be used instead.
* The `ServiceRequest.code.extension:notDoneValueSet` valueset identifies a set of possible coded values representing activities that were not requested, ordered, or performed.
* The `ServiceRequest.subject` is Must Support with Must Support reference to QI-Core Patient
 

**Usage**
The ServiceRequest profile defines the conformance expectations for a ServiceRequest, regardless of whether it is a positive or negative statement. The ServiceRequested and ServiceProhibited profiles represent the positive and negative statements for a service request. 

To create an expression indicating the existence of a service request, use the profile [QICoreServiceRequested](StructureDefinition-qicore-servicerequested.md); to specifically request information that a ServiceRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreServiceProhibited](StructureDefinition-qicore-serviceprohibited.md).

The following expression retrieves instances that meet measure intent for exclusion: 

```
define "Intermittent Pneumatic Compression Devices Not Ordered":
  ["ServiceProhibited": "Application of intermittent pneumatic compression devices (IPC)"] DeviceProhibited
    where (DeviceProhibited.reasonRefused in "Medical Reason"
      or DeviceProhibited.reasonRefused in "Patient Refusal")
```

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation Example with valueset](ServiceRequest-negation-example.md) | Service discontinued; indicates that none of the services in the given `codeOptions` value set were requested. |
| [Negation Example with code](ServiceRequest-negation-example-code.md) | Service discontinued; indicates that the given service, by code, was not requested. |

 

**Usages:**

* Examples for this Profile: [ServiceRequest/negation-example-code](ServiceRequest-negation-example-code.md) and [ServiceRequest/negation-example](ServiceRequest-negation-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-serviceprohibited)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-serviceprohibited.csv), [Excel](../StructureDefinition-qicore-serviceprohibited.xlsx), [Schematron](../StructureDefinition-qicore-serviceprohibited.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-serviceprohibited",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ServiceProhibited"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-serviceprohibited",
  "version" : "8.0.0-ballot",
  "name" : "QICoreServiceProhibited",
  "title" : "QICore Service Prohibited",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negation profile of ServiceRequest for decision support/quality metrics. Indicates a request not to provide a service",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest",
        "mustSupport" : false
      },
      {
        "id" : "ServiceRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.status",
        "short" : "(QI) draft | active | on-hold | completed",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-request-status"
        }
      },
      {
        "id" : "ServiceRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.doNotPerform",
        "short" : "(QI) True if service/procedure should not be performed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : true
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.authoredOn",
        "short" : "(QI) Date request signed",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.reasonCode",
        "short" : "(QI) Explanation/Justification for procedure or service",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "key",
                  "valueId" : "3fdfb5b5-0d5e-4b02-bda5-562629399813"
                },
                {
                  "url" : "purpose",
                  "valueCode" : "extensible"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-condition-code"
        }
      }
    ]
  }
}

```
