# QICore MedicationRequested - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore MedicationRequested 

 
Positive profile of MedicationRequest for decision support/quality metrics. Indicates that a medication was proposed, planned, or ordered. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who or group medication request is for
* status: (QI) active | on-hold | cancelled | completed | stopped | draft
* intent: (QI) proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option
* medication[x]: (QI) Medication to be taken

**QI Elements:**
* doNotPerform: (QI) True if medication was not requested
* reasonCode: (QI) Reason or indication for ordering or not ordering the medication
* category: (QI) Type of medication usage
* authoredOn: (QI) When request was initially authored
* requester: (QI) Who/What requested the Request
* extension(medicationAdherence): (QI) Reported adherence to prescribed medication instructions.
* encounter: (QI) Encounter created as part of encounter/admission/stay
* dispenseRequest: (QI) Medication supply authorization
* reasonReference: (QI) QI-Core Condition or Observation that supports the prescription
* dosageInstruction: (QI) How medication should be taken
* reported[x]: (QI) Reported rather than primary record

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationRequest profile defines the conformance expectations for a MedicationRequest, regardless of whether it is a positive or negative statement. The MedicationRequested and MedicationNotRequested profiles represent the positive and negative statements for a medication order.

To create an expression indicating the existence of a medication request, use the profile [QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md); to specifically request information that a MedicationRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationProhibited](StructureDefinition-qicore-medicationprohibited.md).

The following example illustrates the use of the MedicationRequest profile:

```
define "Antithrombotic Therapy at Discharge":
  ["MedicationRequested": medication in "Antithrombotic Therapy"] Antithrombotic
    where (Antithrombotic.isCommunity() or Antithrombotic.isDischarge())
      and Antithrombotic.intent = 'order'
```

Note that the doNotPerform and statuses indicating positive intent are implied by the use of the MedicationRequested profile.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Penicillin MedicationRequest Example](MedicationRequest-requested-example.md) |

 

**Usages:**

* Examples for this Profile: [MedicationRequest/cmd-example](MedicationRequest-cmd-example.md) and [MedicationRequest/requested-example](MedicationRequest-requested-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationrequested)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationrequested.csv), [Excel](../StructureDefinition-qicore-medicationrequested.xlsx), [Schematron](../StructureDefinition-qicore-medicationrequested.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationrequested",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationRequested"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequested",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationRequested",
  "title" : "QICore MedicationRequested",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Positive profile of MedicationRequest for decision support/quality metrics. Indicates that a medication was proposed, planned, or ordered.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.status",
        "short" : "(QI) active | on-hold | cancelled | completed | stopped | draft",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medicationrequest-status"
        }
      },
      {
        "id" : "MedicationRequest.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) Type of medication usage",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "MedicationRequest.category",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationRequestCategory"
            }
          ],
          "strength" : "example",
          "description" : "A coded concept identifying the category of medication request.  For example, where the medication is to be consumed or administered, or the type of medication treatment.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationrequest-category"
        }
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.doNotPerform",
        "short" : "(QI) True if medication was not requested",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : false
      }
    ]
  }
}

```
