# QICore MedicationDispense Done - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore MedicationDispense Done 

 
Positive profile of MedicationDispense for decision support/quality metrics. Indicates that a medication is being or was dispensed 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* medication[x]: (QI) What medication was supplied
* status: (QI) preparation​ | in-progress​ | on-hold​ | completed​ | stopped​
* subject: (QI) Who the dispense is for

**QI Elements:**
* authorizingPrescription: (QI) Medication order that authorizes the dispense
* extension(recorded): (QI) When recorded
* dosageInstruction: (QI) How the medication is to be used by the patient or administered by the caregiver
* medication[x].extension(codeOptions): (QI) Url of a value set of candidate medications
* daysSupply: (QI) Amount of medication expressed as a timing amount
* whenPrepared: (QI) When product was packaged and reviewed
* quantity: (QI) Amount dispensed
* whenHandedOver: (QI) When product was given out or mailed
* type: (QI) Trial fill, partial fill, emergency fill, etc.

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationDispense profile defines the conformance expectations for a MedicationDispense event, regardless of whether it is a positive or negative statement. The MedicationDispenseDone and MedicationDispenseDeclined profiles represent the positive and negative statements for a MedicationDispense event.

To create an expression indicating existence of a MedicationDispense event, use the profile [QICoreMedicationDispenseDone](StructureDefinition-qicore-medicationdispensedone.md); to specifically request information that a MedicationDispense intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationDispenseDeclined](StructureDefinition-qicore-medicationdispensedeclined.md).

The following example illustrates the use of the MedicationDispenseDone profile

```
define "Dementia Medication Dispensed":
  ["MedicationDispenseDone": "Dementia Medications"]
```

Note that the statuses indicating positive intent are implied by the use of the MedicationDispenseDone profile.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Penicillin MedicationDispense Example](MedicationDispense-done-example.md) |

 

**Usages:**

* Examples for this Profile: [MedicationDispense/done-example](MedicationDispense-done-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationdispensedone)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationdispensedone.csv), [Excel](../StructureDefinition-qicore-medicationdispensedone.xlsx), [Schematron](../StructureDefinition-qicore-medicationdispensedone.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationdispensedone",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationDispensed"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedone",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationDispenseDone",
  "title" : "QICore MedicationDispense Done",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Positive profile of MedicationDispense for decision support/quality metrics. Indicates that a medication is being or was dispensed",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.status",
        "short" : "(QI) preparation​ | in-progress​ | on-hold​ | completed​ | stopped​",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medicationdispense-status"
        }
      }
    ]
  }
}

```
