# QICore ImmunizationEvaluation - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore ImmunizationEvaluation 

 
Defines constraints and extensions on the ImmunizationEvaluation resource for the minimal set of data to query and retrieve a patient's Immunization Evaluation. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* targetDisease: (QI) Evaluation target disease
* date: (QI) Date evaluation was performed
* immunizationEvent: (QI) Immunization being evaluated
* doseStatusReason: (QI) Reason for the dose status
* identifier: (QI) Business identifier
* status: (QI) completed | entered-in-error
* patient: (QI) Who this evaluation is for
* doseStatus: (QI) Status of the dose relative to published recommendations

**Primary code path:**targetDisease

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Example of immunization evaluation](ImmunizationEvaluation-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md)
* Examples for this Profile: [ImmunizationEvaluation/example](ImmunizationEvaluation-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-immunizationevaluation)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-immunizationevaluation.csv), [Excel](../StructureDefinition-qicore-immunizationevaluation.xlsx), [Schematron](../StructureDefinition-qicore-immunizationevaluation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-immunizationevaluation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "targetDisease"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ImmunizationEvaluation"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationevaluation",
  "version" : "8.0.0-ballot",
  "name" : "QICoreImmunizationEvaluation",
  "title" : "QICore ImmunizationEvaluation",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-12-20",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Defines constraints and extensions on the ImmunizationEvaluation resource for the minimal set of data to query and retrieve a patient's Immunization Evaluation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "argonaut-dq-dstu2",
      "uri" : "http://unknown.org/Argonaut-DQ-DSTU2",
      "name" : "Argonaut-DQ-DSTU2"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ImmunizationEvaluation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ImmunizationEvaluation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ImmunizationEvaluation",
        "path" : "ImmunizationEvaluation",
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan"
          }
        ]
      },
      {
        "id" : "ImmunizationEvaluation.identifier",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.identifier",
        "short" : "(QI) Business identifier",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "argonaut-dq-dstu2",
            "map" : "CarePlan.subject"
          }
        ]
      },
      {
        "id" : "ImmunizationEvaluation.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.status",
        "short" : "(QI) completed | entered-in-error"
      },
      {
        "id" : "ImmunizationEvaluation.patient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.patient",
        "short" : "(QI) Who this evaluation is for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "ImmunizationEvaluation.date",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.date",
        "short" : "(QI) Date evaluation was performed",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "ImmunizationEvaluation.authority",
        "path" : "ImmunizationEvaluation.authority",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "ImmunizationEvaluation.targetDisease",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.targetDisease",
        "short" : "(QI) Evaluation target disease",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/immunization-evaluation-target-disease"
        }
      },
      {
        "id" : "ImmunizationEvaluation.immunizationEvent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.immunizationEvent",
        "short" : "(QI) Immunization being evaluated",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization"
            ]
          }
        ]
      },
      {
        "id" : "ImmunizationEvaluation.doseStatus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.doseStatus",
        "short" : "(QI) Status of the dose relative to published recommendations",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status"
        }
      },
      {
        "id" : "ImmunizationEvaluation.doseStatusReason",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ImmunizationEvaluation.doseStatusReason",
        "short" : "(QI) Reason for the dose status",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/immunization-evaluation-dose-status"
        }
      }
    ]
  }
}

```
