# QICore DeviceRequested - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore DeviceRequested 

 
Positive profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order for a device. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* status: (QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown
* modifierExtension(doNotPerform): (QI) Extension
* authoredOn: (QI) When recorded
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code[x]: (QI) Device requested
* code[x].extension(codeOptions): (QI) Url of a value set of candidate devices
* subject: (QI) Focus of request
* modifierExtension.value[x]: (QI) Value of extension
* identifier: (QI) External Request identifier

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The DeviceRequest profile defines the conformance expectations for a DeviceRequest, regardless of whether it is a positive or negative statement. The DeviceRequested and DeviceProhibited profiles derive from DeviceRequest and represent the positive and negative statements for a device request. 

To create an expression indicating existence of a request for a device use the profile [QICoreDeviceRequested](StructureDefinition-qicore-devicerequested.md); to specifically request information that a DeviceRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreDeviceProhibited](StructureDefinition-qicore-deviceprohibited.md).

The following example illustrates the use of DeviceRequested:

```
define "Device Indicating Frailty":
  [DeviceRequested: "Frailty Device"] FrailtyDeviceOrder
    where FrailtyDeviceOrder.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }
```

Note that the doNotPerform and statuses indicating positive intent are implied by the use of the DeviceRequested profile.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [General DeviceRequested Example](DeviceRequest-requested-example.md) |

 

**Usages:**

* Examples for this Profile: [DeviceRequest/requested-example](DeviceRequest-requested-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-devicerequested)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-devicerequested.csv), [Excel](../StructureDefinition-qicore-devicerequested.xlsx), [Schematron](../StructureDefinition-qicore-devicerequested.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-devicerequested",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "DeviceRequested"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequested",
  "version" : "8.0.0-ballot",
  "name" : "QICoreDeviceRequested",
  "title" : "QICore DeviceRequested",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-07-11",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Positive profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order for a device.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceRequest",
        "path" : "DeviceRequest"
      },
      {
        "id" : "DeviceRequest.modifierExtension:doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.modifierExtension",
        "sliceName" : "doNotPerform",
        "short" : "(QI) Extension",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DeviceRequest.doNotPerform"
            ]
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "The do not perform element changes the meaning of the request from a positive to a negative statement"
      },
      {
        "id" : "DeviceRequest.modifierExtension:doNotPerform.value[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.modifierExtension.value[x]",
        "short" : "(QI) Value of extension",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : false
      }
    ]
  }
}

```
