# QICore CommunicationRequest - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore CommunicationRequest 

 
Profile of CommunicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* status: (QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown
* encounter: (QI) Encounter created as part of
* category: (QI) Message category
* sender: (QI) Message sender
* subject: (QI) Focus of message
* doNotPerform: (QI) True if request is prohibiting action
* recipient: (QI) Message recipient

**Primary code path:**category

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [CommunicationRequest Example](CommunicationRequest-example.md) |

 

**Usages:**

* Examples for this Profile: [CommunicationRequest/example](CommunicationRequest-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-communicationrequest)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-communicationrequest.csv), [Excel](../StructureDefinition-qicore-communicationrequest.xlsx), [Schematron](../StructureDefinition-qicore-communicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-communicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "category"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "CommunicationRequest"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communicationrequest",
  "version" : "8.0.0-ballot",
  "name" : "QICoreCommunicationRequest",
  "title" : "QICore CommunicationRequest",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of CommunicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CommunicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CommunicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CommunicationRequest",
        "path" : "CommunicationRequest"
      },
      {
        "id" : "CommunicationRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.status",
        "short" : "(QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown"
      },
      {
        "id" : "CommunicationRequest.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.category",
        "short" : "(QI) Message category",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/communication-category"
        }
      },
      {
        "id" : "CommunicationRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.doNotPerform",
        "short" : "(QI) True if request is prohibiting action"
      },
      {
        "id" : "CommunicationRequest.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.subject",
        "short" : "(QI) Focus of message",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "CommunicationRequest.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.encounter",
        "short" : "(QI) Encounter created as part of",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "CommunicationRequest.recipient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.recipient",
        "short" : "(QI) Message recipient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careteam"
            ]
          }
        ]
      },
      {
        "id" : "CommunicationRequest.sender",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "CommunicationRequest.sender",
        "short" : "(QI) Message sender",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ]
          }
        ]
      }
    ]
  }
}

```
