# QICore Communication - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore Communication 

 
Profile of Communication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* topic.extension(codeOptions): (QI) Url of a value set of candidate topics
* sender: (QI) Message sender
* sent: (QI) When sent
* topic: (QI) Description of the purpose/content
* subject: (QI) Focus of message
* received: (QI) When received
* status: (QI) preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown
* recipient: (QI) Message recipient

**Primary code path:**topic

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Communication profile defines the conformance expectations for a Communication event, regardless of whether it is a positive or negative statement. To ensure instances retrieved meet positive intent, applications should check the status as illustrated in this example:

```
define "Lab results communicated":
   ["Communication": "report-labs"] LabReport
       where LabReport.topic = 'report-labs'
       and LabReport.status = 'completed'
       and LabReport.reasonCode = 'Serum pregnancy test negative (finding)'

```

Alternatively, applications may make use of the positive and negative profiles to address status. The CommunicationDone and CommunicationNotDone profiles represent the positive and negative statements for a communication event.

To create an expression indicating existence of a communication, use the profile [QICoreCommunicationDone](StructureDefinition-qicore-communicationdone.md); to specifically request information that a communication intentionally did not occur for a medical, patient or system reason, use the profile [QICoreCommunicationNotDone](StructureDefinition-qicore-communicationnotdone.md).

See the [patterns](patterns.md) page for implementation and usage patterns.

### Examples

 

| |
| :--- |
| [Written Alert Example](Communication-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore CommunicationDone](StructureDefinition-qicore-communicationdone.md) and [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md)
* Examples for this Profile: [Communication/example](Communication-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-communication)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-communication.csv), [Excel](../StructureDefinition-qicore-communication.xlsx), [Schematron](../StructureDefinition-qicore-communication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-communication",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "topic"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Communication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communication",
  "version" : "8.0.0-ballot",
  "name" : "QICoreCommunication",
  "title" : "QICore Communication",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-08-01",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Communication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Communication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Communication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Communication",
        "path" : "Communication",
        "constraint" : [
          {
            "key" : "com-1",
            "severity" : "error",
            "human" : "to indicate what communication, either at least one coding in the topic or a codeOptions extension shall be provided",
            "expression" : "topic.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor (topic.coding.exists() or topic.text.exists())"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Communication.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.status",
        "short" : "(QI) preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown"
      },
      {
        "id" : "Communication.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.subject",
        "short" : "(QI) Focus of message",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "Communication.topic",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.topic",
        "short" : "(QI) Description of the purpose/content",
        "condition" : ["com-1"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://terminology.hl7.org/ValueSet/communication-topic|1.0.0"
        }
      },
      {
        "id" : "Communication.topic.extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.topic.extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate topics",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the purpose or content of the communication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/codeOptions|8.0.0-ballot"
            ]
          }
        ],
        "condition" : ["com-1"]
      },
      {
        "id" : "Communication.sent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.sent",
        "short" : "(QI) When sent"
      },
      {
        "id" : "Communication.received",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.received",
        "short" : "(QI) When received"
      },
      {
        "id" : "Communication.recipient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.recipient",
        "short" : "(QI) Message recipient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careteam",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "Communication.sender",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Communication.sender",
        "short" : "(QI) Message sender",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ]
          }
        ]
      }
    ]
  }
}

```
