# QICore ClaimResponse - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore ClaimResponse 

 
The QI-Core ClaimResponse profile is used to provide the results of the adjudication and/or authorization of a set of healthcare-related products and services for a patient against the patient's insurance coverages, or to respond with what the adjudication would be for a supplied set of products or services should they be actually supplied to the patient. It identifies the mandatory core elements, extensions, vocabularies and value sets which**SHALL**be present in the ClaimResponse resource when using this profile 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* request: (QI) Id of resource triggering adjudication
* requestor: (QI) Party responsible for the claim
* patient: (QI) The recipient of the products and services
* created: (QI) Response creation date
* status: (QI) active | cancelled | draft | entered-in-error
* use: (QI) claim | preauthorization | predetermination
* item: (QI) Adjudication for claim line items
* type: (QI) More granular claim type
* insurer: (QI) Party responsible for reimbursement

**Primary code path:**type

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Preauthorization Vision ClaimResponse Example](ClaimResponse-example.md) |

 

**Usages:**

* Examples for this Profile: [ClaimResponse/example](ClaimResponse-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-claimresponse)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-claimresponse.csv), [Excel](../StructureDefinition-qicore-claimresponse.xlsx), [Schematron](../StructureDefinition-qicore-claimresponse.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-claimresponse",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "type"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ClaimResponse"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claimresponse",
  "version" : "8.0.0-ballot",
  "name" : "QICoreClaimResponse",
  "title" : "QICore ClaimResponse",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-04-20",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The QI-Core ClaimResponse profile is used to provide the results of the adjudication and/or authorization of a set of healthcare-related products and services for a patient against the patient's insurance coverages, or to respond with what the adjudication would be for a supplied set of products or services should they be actually supplied to the patient. It identifies the mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the ClaimResponse resource when using this profile",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClaimResponse",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClaimResponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClaimResponse",
        "path" : "ClaimResponse",
        "mustSupport" : false
      },
      {
        "id" : "ClaimResponse.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.status",
        "short" : "(QI) active | cancelled | draft | entered-in-error",
        "definition" : "The status of the resource instance.",
        "comment" : "This element is labeled as a modifier because the status contains codes that mark the resource as not currently valid.",
        "requirements" : "Need to track the status of the resource as 'draft' resources may undergo further edits while 'active' resources are immutable and may only have their status changed to 'cancelled'.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.status",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "active",
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because it is a status element that contains status entered-in-error which means that the resource should not be treated as valid",
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ClaimResponseStatus"
            }
          ],
          "strength" : "required",
          "description" : "A code specifying the state of the resource instance.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/fm-status|4.0.1"
        }
      },
      {
        "id" : "ClaimResponse.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.type",
        "short" : "(QI) More granular claim type",
        "definition" : "A finer grained suite of claim type codes which may convey additional information such as Inpatient vs Outpatient and/or a specialty service.",
        "comment" : "This may contain the local bill type codes, for example the US UB-04 bill type code or the CMS bill type.",
        "requirements" : "Some jurisdictions need a finer grained claim type for routing and adjudication.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.type",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ClaimType"
            }
          ],
          "strength" : "extensible",
          "description" : "The type or discipline-style of the claim.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/claim-type"
        }
      },
      {
        "id" : "ClaimResponse.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.use",
        "short" : "(QI) claim | preauthorization | predetermination",
        "definition" : "A code to indicate whether the nature of the request is: to request adjudication of products and services previously rendered; or requesting authorization and adjudication for provision in the future; or requesting the non-binding adjudication of the listed products and services which could be provided in the future.",
        "requirements" : "This element is required to understand the nature of the request for adjudication.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.use",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "preauthorization",
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Use"
            }
          ],
          "strength" : "required",
          "description" : "Claim, preauthorization, predetermination.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/claim-use|4.0.1"
        }
      },
      {
        "id" : "ClaimResponse.patient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.patient",
        "short" : "(QI) The recipient of the products and services",
        "definition" : "The party to whom the professional services and/or products have been supplied or are being considered and for whom actual for facast reimbursement is sought.",
        "requirements" : "The patient must be supplied to the insurer so that confirmation of coverage and service hstory may be considered as part of the authorization and/or adjudiction.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.patient",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "ClaimResponse.created",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.created",
        "short" : "(QI) Response creation date",
        "definition" : "The date this resource was created.",
        "requirements" : "Need to record a timestamp for use by both the recipient and the issuer.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.created",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "ClaimResponse.insurer",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.insurer",
        "short" : "(QI) Party responsible for reimbursement",
        "definition" : "The party responsible for authorization, adjudication and reimbursement.",
        "requirements" : "To be a valid claim, preauthorization or predetermination there must be a party who is responsible for adjudicating the contents against a policy which provides benefits for the patient.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.insurer",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "ClaimResponse.requestor",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.requestor",
        "short" : "(QI) Party responsible for the claim",
        "definition" : "The provider which is responsible for the claim, predetermination or preauthorization.",
        "comment" : "Typically this field would be 1..1 where this party is responsible for the claim but not necessarily professionally responsible for the provision of the individual products and services listed below.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.requestor",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole"
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "ClaimResponse.request",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.request",
        "short" : "(QI) Id of resource triggering adjudication",
        "definition" : "Original request resource reference.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.request",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claim"
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "ClaimResponse.item",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Item"
          },
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.item",
        "short" : "(QI) Adjudication for claim line items",
        "definition" : "A claim line. Either a simple (a product or service) or a 'group' of details which can also be a simple items or groups of sub-details.",
        "requirements" : "The adjudication for items provided on the claim.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "ClaimResponse.item",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "ClaimResponse.item.adjudication",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Adjudication"
          },
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.item.adjudication",
        "short" : "(QI) Adjudication details",
        "definition" : "If this item is a group then the values here are a summary of the adjudication of the detail items. If this item is a simple product or service then this is the result of the adjudication of this item.",
        "requirements" : "The adjudication results conveys the insurer's assessment of the item provided in the claim under the terms of the patient's insurance coverage.",
        "min" : 1,
        "max" : "*",
        "base" : {
          "path" : "ClaimResponse.item.adjudication",
          "min" : 1,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "ClaimResponse.item.adjudication.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.item.adjudication.category",
        "short" : "(QI) This code is fixed to 'submitted' to indicate that the adjudication result is on what was submitted.",
        "definition" : "A code to indicate the information type of this adjudication record. Information types may include the value submitted, maximum values or percentages allowed or payable under the plan, amounts that: the patient is responsible for in aggregate or pertaining to this item; amounts paid by other coverages; and, the benefit payable for this item.",
        "comment" : "For example codes indicating: Co-Pay, deductible, eligible, benefit, tax, etc.",
        "requirements" : "Needed to enable understanding of the context of the other information in the adjudication.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.item.adjudication.category",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
              "code" : "submitted"
            }
          ]
        },
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "ClaimResponse.item.adjudication.amount",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.item.adjudication.amount",
        "short" : "(QI) Monetary amount",
        "definition" : "Monetary amount associated with the category.",
        "comment" : "For example: amount submitted, eligible amount, co-payment, and benefit payable.",
        "requirements" : "Most adjuciation categories convey a monetary amount.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.item.adjudication.amount",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Money"
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "ClaimResponse.item.detail.detailSequence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ClaimResponse.item.detail.detailSequence",
        "short" : "(QI) Claim detail instance identifier",
        "definition" : "A number to uniquely reference the claim detail entry.",
        "requirements" : "Necessary to provide a mechanism to link the adjudication result to the submitted claim detail.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "ClaimResponse.item.detail.detailSequence",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "positiveInt"
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      }
    ]
  }
}

```
