# ServiceRequested appendix example - QI-Core Implementation Guide v8.0.0-ballot

## Example ServiceRequest: ServiceRequested appendix example

Language: en

Profile: [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)

**status**: Completed

**intent**: Order

**category**: Surgical Procedure

**priority**: Urgent

**doNotPerform**: false

**code**: Excision of appendix (procedure)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-04-05 --> 2013-04-05

**asNeeded**: true

**authoredOn**: 2013-04-04

**reasonCode**: Abdominal pain (finding)

**bodySite**: Appendix structure



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "servicerequested-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequested"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387713003",
          "display" : "Surgical Procedure"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "doNotPerform" : false,
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80146002",
        "display" : "Excision of appendix (procedure)"
      }
    ],
    "text" : "Excision of appendix (procedure)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrencePeriod" : {
    "start" : "2013-04-05",
    "end" : "2013-04-05"
  },
  "asNeededBoolean" : true,
  "authoredOn" : "2013-04-04",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "21522001",
          "display" : "Abdominal pain (finding)"
        }
      ]
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66754008",
          "display" : "Appendix structure"
        }
      ]
    }
  ]
}

```
