# ServiceRequest positive example with a code - QI-Core Implementation Guide v8.0.0-ballot

## Example ServiceRequest: ServiceRequest positive example with a code

Language: en

Profile: [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)

**status**: Active

**intent**: Proposal

**priority**: Urgent

**code**: Graduated compression elastic hosiery (physical object)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-04-05

**authoredOn**: 2013-04-04



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "proposal-example-code",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequested"
    ]
  },
  "language" : "en",
  "status" : "active",
  "intent" : "proposal",
  "priority" : "urgent",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "348681001",
        "display" : "Graduated compression elastic hosiery (physical object)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-04-05",
  "authoredOn" : "2013-04-04"
}

```
