# ProcedureNotDone with code example - QI-Core Implementation Guide v8.0.0-ballot

## Example Procedure: ProcedureNotDone with code example

Language: en

**Extension Definition for Procedure.recorded for Version 5.0**: 2013-04-05 10:30:00-0400

**status**: Not Done

**statusReason**: Complication of medical care (disorder)

**code**: Graduated compression elastic hosiery (physical object)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**reasonCode**: Patient requests alternative treatment



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "negation-with-code-example",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Procedure.recorded",
      "valueDateTime" : "2013-04-05T10:30:00-04:00"
    }
  ],
  "status" : "not-done",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "35688006",
        "display" : "Complication of medical care (disorder)"
      }
    ]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "348681001",
        "display" : "Graduated compression elastic hosiery (physical object)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "182890002",
          "display" : "Patient requests alternative treatment"
        }
      ]
    }
  ]
}

```
