# Procedure general example - QI-Core Implementation Guide v8.0.0-ballot

## Example Procedure: Procedure general example

Language: en

Profile: [QICore Procedure](StructureDefinition-qicore-procedure.md)

**Extension Definition for Procedure.recorded for Version 5.0**: 2013-04-05 09:35:00-0400

**status**: Completed

**code**: Excision of appendix (procedure)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**performed**: 2013-04-05 09:20:00-0400 --> 2013-04-05 10:30:00-0400

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Dr Cecil Surgeon](Practitioner-example.md) |

**reasonCode**: Abdominal pain (finding)

**bodySite**: Appendix structure

**report**: [Diagnostic Report for 'CBC panel - Blood by Automated count' for '->Peter Chalmers'](DiagnosticReport-example.md)



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Procedure.recorded",
      "valueDateTime" : "2013-04-05T09:35:00-04:00"
    }
  ],
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "80146002",
        "display" : "Excision of appendix (procedure)"
      }
    ],
    "text" : "Excision of appendix (procedure)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "performedPeriod" : {
    "start" : "2013-04-05T09:20:00-04:00",
    "end" : "2013-04-05T10:30:00-04:00"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/example",
        "display" : "Dr Cecil Surgeon"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "21522001",
          "display" : "Abdominal pain (finding)"
        }
      ]
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66754008",
          "display" : "Appendix structure"
        }
      ]
    }
  ],
  "report" : [
    {
      "reference" : "DiagnosticReport/example"
    }
  ]
}

```
