# Date and time of obstetric delivery example - QI-Core Implementation Guide v8.0.0-ballot

## Example Observation: Date and time of obstetric delivery example

Language: en

Profile: [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)

**status**: Final

**category**: exam

**code**: Date and time of obstetric delivery

**subject**: [Sarah Hugankiss (official) Female, DoB: 1946-09-25 ( Medical record number (use: usual, period: 1995-05-06 --> (ongoing)))](Patient-example-2.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**effective**: 2023-10-22 06:30:00+0500 --> 2023-10-22 08:30:10+0500

**issued**: 2023-10-22 07:30:10+0500

**performer**: [Hendricks Country Hospital](Organization-example1.md)

**value**: 2023-10-22 07:23:52+0500



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "example-obstetric-delivery",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "exam"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "93857-1",
        "display" : "Date and time of obstetric delivery"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example-2"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "effectivePeriod" : {
    "start" : "2023-10-22T06:30:00+05:00",
    "end" : "2023-10-22T08:30:10+05:00"
  },
  "issued" : "2023-10-22T07:30:10+05:00",
  "performer" : [
    {
      "reference" : "Organization/example1",
      "display" : "Hendricks Country Hospital"
    }
  ],
  "valueDateTime" : "2023-10-22T07:23:52+05:00"
}

```
