# NutrientOrder example - QI-Core Implementation Guide v8.0.0-ballot

## Example NutritionOrder: NutrientOrder example

Language: en

Profile: [QICore NutritionOrder](StructureDefinition-qicore-nutritionorder.md)

**identifier**: `http://example.org/nutrition-requests`/123

**status**: Active

**intent**: Order

**patient**: [Peter Chalmers](Patient-example.md)

**encounter**: [Inpatient](Encounter-example.md)

**dateTime**: 2014-09-17

**orderer**: [Dr Adam Careful](Practitioner-example.md)

**allergyIntolerance**: [Cashew Nuts](AllergyIntolerance-example.md)

**foodPreferenceModifier**: Dairy Free

> **oralDiet****type**:Diabetic diet**schedule**: 3 per 1 day

### Nutrients

| | | |
| :--- | :--- | :--- |
| - | **Modifier** | **Amount** |
| * | Carbohydrate | 75 grams(Details: UCUM codeg = 'g') |




## Resource Content

```json
{
  "resourceType" : "NutritionOrder",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-nutritionorder"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://example.org/nutrition-requests",
      "value" : "123"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "patient" : {
    "reference" : "Patient/example",
    "display" : "Peter Chalmers"
  },
  "encounter" : {
    "reference" : "Encounter/example",
    "display" : "Inpatient"
  },
  "dateTime" : "2014-09-17",
  "orderer" : {
    "reference" : "Practitioner/example",
    "display" : "Dr Adam Careful"
  },
  "allergyIntolerance" : [
    {
      "reference" : "AllergyIntolerance/example",
      "display" : "Cashew Nuts"
    }
  ],
  "foodPreferenceModifier" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/diet",
          "code" : "dairy-free"
        }
      ]
    }
  ],
  "oralDiet" : {
    "type" : [
      {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "160670007",
            "display" : "Diabetic diet"
          }
        ],
        "text" : "Diabetic diet"
      }
    ],
    "schedule" : [
      {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2015-02-10"
          },
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d"
        }
      }
    ],
    "nutrient" : [
      {
        "modifier" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "2331003",
              "display" : "Carbohydrate"
            }
          ]
        },
        "amount" : {
          "value" : 75,
          "unit" : "grams",
          "system" : "http://unitsofmeasure.org",
          "code" : "g"
        }
      }
    ]
  }
}

```
