# MedicationStatment example - QI-Core Implementation Guide v8.0.0-ballot

## Example MedicationStatement: MedicationStatment example

Language: en

Profile: [QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md)

**status**: Active

**medication**: [Medication alemtuzumab 10 MG/ML [Lemtrada]](Medication-example.md)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**effective**: 2012-06-01 14:30:00+1400

**dateAsserted**: 2012-05-14 15:00:00+1400

**informationSource**: [Practitioner Adam Careful](Practitioner-example.md)

**derivedFrom**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

> **dosage****timing**: 3 per 1 day**route**:oral administration of treatment

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 10 ml(Details: UCUM codeml = 'ml') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationstatement"
    ]
  },
  "language" : "en",
  "status" : "active",
  "medicationReference" : {
    "reference" : "Medication/example"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "effectiveDateTime" : "2012-06-01T14:30:00+14:00",
  "dateAsserted" : "2012-05-14T15:00:00+14:00",
  "informationSource" : {
    "reference" : "Practitioner/example"
  },
  "derivedFrom" : [
    {
      "reference" : "MedicationRequest/example"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "394899003",
            "display" : "oral administration of treatment"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 10,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "ml"
          }
        }
      ]
    }
  ]
}

```
