# MedicationDispense positive example - QI-Core Implementation Guide v8.0.0-ballot

## Example MedicationDispense: MedicationDispense positive example

Language: en

Profile: [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md)

**Extension Definition for MedicationDispense.recorded for Version 5.0**: 2017-01-17

**status**: Completed

**medication**: [Medication alemtuzumab 10 MG/ML [Lemtrada]](Medication-example.md)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Practitioner Adam Careful](Practitioner-example.md) |

**authorizingPrescription**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

**quantity**: 100 ml(Details: UCUM codeml = 'ml')

**daysSupply**: 30 Day(Details: UCUM coded = 'd')

**whenPrepared**: 2012-05-30 16:20:00+0000

**whenHandedOver**: 2012-05-31 10:20:00+0000

**destination**: [Location South Wing, second floor](Location-example.md)

**receiver**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

> **dosageInstruction****timing**: 3 per 1 day**route**:oral administration of treatment

### DoseAndRates

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Dose[x]** |
| * | Ordered | 5 ml(Details: UCUM codeml = 'ml') |


### Substitutions

| | | |
| :--- | :--- | :--- |
| - | **WasSubstituted** | **Type** |
| * | false | No substitution occurred or is permitted. |



## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "done-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedone"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.recorded",
      "valueDateTime" : "2017-01-17"
    }
  ],
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/example"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/example"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/example"
    }
  ],
  "quantity" : {
    "value" : 100,
    "unit" : "ml",
    "system" : "http://unitsofmeasure.org",
    "code" : "ml"
  },
  "daysSupply" : {
    "value" : 30,
    "unit" : "Day",
    "system" : "http://unitsofmeasure.org",
    "code" : "d"
  },
  "whenPrepared" : "2012-05-30T16:20:00+00:00",
  "whenHandedOver" : "2012-05-31T10:20:00+00:00",
  "destination" : {
    "reference" : "Location/example"
  },
  "receiver" : [
    {
      "reference" : "Patient/example"
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "394899003",
            "display" : "oral administration of treatment"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "ordered",
                "display" : "Ordered"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 5,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "ml"
          }
        }
      ]
    }
  ],
  "substitution" : {
    "wasSubstituted" : false,
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution",
          "code" : "N",
          "display" : "none"
        }
      ],
      "text" : "No substitution occurred or is permitted."
    }
  }
}

```
