# MedicationAdministration negation with value set example - QI-Core Implementation Guide v8.0.0-ballot

## Example MedicationAdministration: MedicationAdministration negation with value set example

Language: en

Profile: [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md)

**status**: Not Done

**statusReason**: Drug treatment not indicated (situation)

**medication**: Value Set: Low Dose Unfractionated Heparin for VTE Prophylaxis (value set: [Medication Brand Name](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.88.12.80.16/expansion))

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**context**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**supportingInformation**: [Condition Burn of ear](Condition-example.md)

**effective**: 2015-01-15 14:30:00+0100 --> 2015-01-15 14:30:00+0100

**request**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

**note**: 

> 

Patient started Bupropion this morning - will administer in a reduced dose tomorrow


### Dosages

| | | |
| :--- | :--- | :--- |
| - | **Route** | **Dose** |
| * | Intravenous route (qualifier value) | 3 mg(Details: UCUM codemg = 'mg') |



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationnotdone"
    ]
  },
  "language" : "en",
  "status" : "not-done",
  "statusReason" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "183966005",
          "display" : "Drug treatment not indicated (situation)"
        }
      ]
    }
  ],
  "medicationCodeableConcept" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.88.12.80.16"
      }
    ],
    "text" : "Value Set: Low Dose Unfractionated Heparin for VTE Prophylaxis"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "context" : {
    "reference" : "Encounter/example"
  },
  "supportingInformation" : [
    {
      "reference" : "Condition/example"
    }
  ],
  "effectivePeriod" : {
    "start" : "2015-01-15T14:30:00+01:00",
    "end" : "2015-01-15T14:30:00+01:00"
  },
  "request" : {
    "reference" : "MedicationRequest/example"
  },
  "note" : [
    {
      "text" : "Patient started Bupropion this morning - will administer in a reduced dose tomorrow"
    }
  ],
  "dosage" : {
    "route" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "47625008",
          "display" : "Intravenous route (qualifier value)"
        }
      ]
    },
    "dose" : {
      "value" : 3,
      "unit" : "mg",
      "system" : "http://unitsofmeasure.org",
      "code" : "mg"
    }
  }
}

```
