# ImmunizationRecommendation example - QI-Core Implementation Guide v8.0.0-ballot

## Example ImmunizationRecommendation: ImmunizationRecommendation example

Language: en

Profile: [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md)

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/6.5.0/NamingSystem-uri.html)/urn:oid:1.3.6.1.4.1.21367.2005.3.7.1235

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**date**: 2015-02-09 11:04:15-0500

> **recommendation****vaccineCode**:Vaccine product containing only inactivated whole Hepatitis A virus HM-175 strain antigen (medicinal product)**forecastStatus**:Not Complete
> **dateCriterion****code**:Earliest date to give**value**: 2015-12-01 00:00:00-0500

> **dateCriterion****code**:Date vaccine due**value**: 2015-12-01 00:00:00-0500

> **dateCriterion****code**:Date when overdue for immunization**value**: 2016-12-28 00:00:00-0500
**description**: First sequence in protocol**series**: Vaccination Series 1**doseNumber**: 1**supportingImmunization**:[Immunization: identifier = OID:1.3.6.1.4.1.21367.2005.3.7.1234; status = completed; vaccineCode = Fluvax; occurrence[x] = 2013-01-01; recorded = 2013-01-10; primarySource = true; lotNumber = AAJN11K; expirationDate = 2015-02-15; site = left arm; route = Injection, intramuscular; doseQuantity = 5 mg; note = Notes on adminstration of vaccine; reasonCode = Procedure to meet occupational requirement](Immunization-example.md)**supportingPatientInformation**:[Observation Hemoglobin [Mass/volume] in Venous blood](Observation-example.md)



## Resource Content

```json
{
  "resourceType" : "ImmunizationRecommendation",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationrecommendation"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.3.6.1.4.1.21367.2005.3.7.1235"
    }
  ],
  "patient" : {
    "reference" : "Patient/example"
  },
  "date" : "2015-02-09T11:04:15.817-05:00",
  "recommendation" : [
    {
      "vaccineCode" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1010308001",
              "display" : "Vaccine product containing only inactivated whole Hepatitis A virus HM-175 strain antigen (medicinal product)"
            }
          ]
        }
      ],
      "forecastStatus" : {
        "text" : "Not Complete"
      },
      "dateCriterion" : [
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "30981-5",
                "display" : "Earliest date to give"
              }
            ]
          },
          "value" : "2015-12-01T00:00:00-05:00"
        },
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "30980-7",
                "display" : "Date vaccine due"
              }
            ]
          },
          "value" : "2015-12-01T00:00:00-05:00"
        },
        {
          "code" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "59778-1",
                "display" : "Date when overdue for immunization"
              }
            ]
          },
          "value" : "2016-12-28T00:00:00-05:00"
        }
      ],
      "description" : "First sequence in protocol",
      "series" : "Vaccination Series 1",
      "doseNumberPositiveInt" : 1,
      "supportingImmunization" : [
        {
          "reference" : "Immunization/example"
        }
      ],
      "supportingPatientInformation" : [
        {
          "reference" : "Observation/example"
        }
      ]
    }
  ]
}

```
