# ImmunizationEvaluaion example - QI-Core Implementation Guide v8.0.0-ballot

## Example ImmunizationEvaluation: ImmunizationEvaluaion example

Language: en

Profile: [QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md)

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/6.5.0/NamingSystem-uri.html)/urn:oid:1.3.6.1.4.1.21367.2005.3.7.1234

**status**: Completed

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**date**: 2013-01-10

**authority**: [Organization Health Level Seven International](Organization-example.md)

**targetDisease**: Gestational rubella syndrome

**immunizationEvent**: [Immunization: identifier = OID:1.3.6.1.4.1.21367.2005.3.7.1234; status = completed; vaccineCode = Fluvax; occurrence[x] = 2013-01-01; recorded = 2013-01-10; primarySource = true; lotNumber = AAJN11K; expirationDate = 2015-02-15; site = left arm; route = Injection, intramuscular; doseQuantity = 5 mg; note = Notes on adminstration of vaccine; reasonCode = Procedure to meet occupational requirement](Immunization-example.md)

**doseStatus**: Valid

**series**: Vaccination Series 1

**doseNumber**: 1

**seriesDoses**: 3



## Resource Content

```json
{
  "resourceType" : "ImmunizationEvaluation",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationevaluation"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.3.6.1.4.1.21367.2005.3.7.1234"
    }
  ],
  "status" : "completed",
  "patient" : {
    "reference" : "Patient/example"
  },
  "date" : "2013-01-10",
  "authority" : {
    "reference" : "Organization/example"
  },
  "targetDisease" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1857005"
      }
    ]
  },
  "immunizationEvent" : {
    "reference" : "Immunization/example"
  },
  "doseStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/immunization-evaluation-dose-status",
        "code" : "valid",
        "display" : "Valid"
      }
    ]
  },
  "series" : "Vaccination Series 1",
  "doseNumberPositiveInt" : 1,
  "seriesDosesPositiveInt" : 3
}

```
