# Immunization negation with value set example - QI-Core Implementation Guide v8.0.0-ballot

## Example Immunization: Immunization negation with value set example

Language: en

Profile: [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md)

**status**: Not Done

**statusReason**: Drug declined by patient

**vaccineCode**: Value Set: DTaP Vaccine (value set: [DTaP Vaccine](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.464.1003.196.11.1212/expansion))

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-01-10

**recorded**: 2013-01-10

**primarySource**: true



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationnotdone"
    ]
  },
  "language" : "en",
  "status" : "not-done",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "182895007",
        "display" : "Drug declined by patient"
      }
    ]
  },
  "vaccineCode" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.464.1003.196.11.1212"
      }
    ],
    "text" : "Value Set: DTaP Vaccine"
  },
  "patient" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-01-10",
  "recorded" : "2013-01-10",
  "primarySource" : true
}

```
