# Immunization negation with code example - QI-Core Implementation Guide v8.0.0-ballot

## Example Immunization: Immunization negation with code example

Language: en

Profile: [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md)

**status**: Not Done

**statusReason**: Drug declined by patient

**vaccineCode**: Influenza A monovalent (H5N1), adjuvanted, National stockpile 2013

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-01-10

**recorded**: 2013-01-10

**primarySource**: true



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "negation-example-code",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationnotdone"
    ]
  },
  "language" : "en",
  "status" : "not-done",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "182895007",
        "display" : "Drug declined by patient"
      }
    ]
  },
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/cvx",
        "code" : "160",
        "display" : "Influenza A monovalent (H5N1), adjuvanted, National stockpile 2013"
      },
      {
        "system" : "http://hl7.org/fhir/sid/ndc",
        "code" : "49281012165"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-01-10",
  "recorded" : "2013-01-10",
  "primarySource" : true
}

```
