# Immunization general example - QI-Core Implementation Guide v8.0.0-ballot

## Example Immunization: Immunization general example

Language: en

Profile: [QICore Immunization](StructureDefinition-qicore-immunization.md)

**identifier**: [Uniform Resource Identifier (URI)](http://terminology.hl7.org/6.5.0/NamingSystem-uri.html)/urn:oid:1.3.6.1.4.1.21367.2005.3.7.1234

**status**: Completed

**vaccineCode**: Fluvax (Influenza)

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-01-01

**recorded**: 2013-01-10

**primarySource**: true

**location**: [Location South Wing, second floor](Location-example.md)

**manufacturer**: [Organization Health Level Seven International](Organization-example.md)

**lotNumber**: AAJN11K

**expirationDate**: 2015-02-15

**site**: left arm

**route**: Injection, intramuscular

**doseQuantity**: 5 mg(Details: UCUM codemg = 'mg')

> **performer****function**:Ordering Provider**actor**:[Practitioner Adam Careful](Practitioner-example.md)

> **performer****function**:Administering Provider**actor**:[Practitioner Adam Careful](Practitioner-example.md)

**note**: 

> 

Notes on adminstration of vaccine


**reasonCode**: Procedure to meet occupational requirement

### Reactions

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Date** | **Detail** | **Reported** |
| * | 2013-01-10 | [Observation Hemoglobin [Mass/volume] in Venous blood](Observation-example.md) | true |

### ProtocolApplieds

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Series** | **Authority** | **TargetDisease** | **DoseNumber[x]** | **SeriesDoses[x]** |
| * | Vaccination Series 1 | [Organization Health Level Seven International](Organization-example.md) | Gestational rubella syndrome | 1 | 2 |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:1.3.6.1.4.1.21367.2005.3.7.1234"
    }
  ],
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "urn:oid:1.2.36.1.2001.1005.17",
        "code" : "FLUVAX"
      }
    ],
    "text" : "Fluvax (Influenza)"
  },
  "patient" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-01-01",
  "recorded" : "2013-01-10",
  "primarySource" : true,
  "location" : {
    "reference" : "Location/example"
  },
  "manufacturer" : {
    "reference" : "Organization/example"
  },
  "lotNumber" : "AAJN11K",
  "expirationDate" : "2015-02-15",
  "site" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActSite",
        "code" : "LA",
        "display" : "left arm"
      }
    ]
  },
  "route" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
        "code" : "IM",
        "display" : "Injection, intramuscular"
      }
    ]
  },
  "doseQuantity" : {
    "value" : 5,
    "system" : "http://unitsofmeasure.org",
    "code" : "mg"
  },
  "performer" : [
    {
      "function" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
            "code" : "OP"
          }
        ]
      },
      "actor" : {
        "reference" : "Practitioner/example"
      }
    },
    {
      "function" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
            "code" : "AP"
          }
        ]
      },
      "actor" : {
        "reference" : "Practitioner/example"
      }
    }
  ],
  "note" : [
    {
      "text" : "Notes on adminstration of vaccine"
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "429060002"
        }
      ]
    }
  ],
  "reaction" : [
    {
      "date" : "2013-01-10",
      "detail" : {
        "reference" : "Observation/example"
      },
      "reported" : true
    }
  ],
  "protocolApplied" : [
    {
      "series" : "Vaccination Series 1",
      "authority" : {
        "reference" : "Organization/example"
      },
      "targetDisease" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1857005"
            }
          ]
        }
      ],
      "doseNumberPositiveInt" : 1,
      "seriesDosesPositiveInt" : 2
    }
  ]
}

```
