# Flag example - QI-Core Implementation Guide v8.0.0-ballot

## Example Flag: Flag example

Language: en

Profile: [QICore Flag](StructureDefinition-qicore-flag.md)

**identifier**: 12345

**status**: Inactive

**category**: Administrative

**code**: Patient is accident prone

**subject**: [Peter Patient](Patient-example.md)

**period**: 2024-01-17 --> 2024-12-01

**author**: [Nancy Nurse](Practitioner-example.md)



## Resource Content

```json
{
  "resourceType" : "Flag",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-flag"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "value" : "12345"
    }
  ],
  "status" : "inactive",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/flag-category",
          "code" : "admin",
          "display" : "Administrative"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "165002",
        "display" : "Accident-prone"
      }
    ],
    "text" : "Patient is accident prone"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Peter Patient"
  },
  "period" : {
    "start" : "2024-01-17",
    "end" : "2024-12-01"
  },
  "author" : {
    "reference" : "Practitioner/example",
    "display" : "Nancy Nurse"
  }
}

```
