# Encounter example - QI-Core Implementation Guide v8.0.0-ballot

## Example Encounter: Encounter example

Language: en

Profile: [QICore Encounter](StructureDefinition-qicore-encounter.md)

**status**: In Progress

**class**: [ActCode: IMP](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-IMP) (inpatient encounter)

**type**: Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

### Diagnoses

| | |
| :--- | :--- |
| - | **Condition** |
| * | [Condition Appendicitis (disorder)](Condition-appendicitis-example.md) |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
    ]
  },
  "language" : "en",
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "IMP",
    "display" : "inpatient encounter"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.ama-assn.org/go/cpt",
          "code" : "99223",
          "display" : "Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded."
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "diagnosis" : [
    {
      "condition" : {
        "reference" : "Condition/appendicitis-example"
      }
    }
  ]
}

```
