# DeviceRequest negation with code example - QI-Core Implementation Guide v8.0.0-ballot

## Example DeviceRequest: DeviceRequest negation with code example

Language: en

Profile: [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md)

**Extension Definition for DeviceRequest.doNotPerform for Version 5.0**: true

**status**: Completed

**intent**: Original Order

**code**: Venous foot pump, device (physical object)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authoredOn**: 2016-04-05 09:20:00-0400

**reasonCode**: Patient requests alternative treatment



## Resource Content

```json
{
  "resourceType" : "DeviceRequest",
  "id" : "negation-with-code-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited"
    ]
  },
  "language" : "en",
  "modifierExtension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-DeviceRequest.doNotPerform",
      "valueBoolean" : true
    }
  ],
  "status" : "completed",
  "intent" : "original-order",
  "codeCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/731000124108",
        "code" : "442023007",
        "display" : "Venous foot pump, device (physical object)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2016-04-05T09:20:00-04:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "182890002",
          "display" : "Patient requests alternative treatment"
        }
      ]
    }
  ]
}

```
