# Communication example - QI-Core Implementation Guide v8.0.0-ballot

## Example Communication: Communication example

Language: en

Profile: [QICore Communication](StructureDefinition-qicore-communication.md)

**partOf**: Serum Potassium Observation

**status**: On Hold

**statusReason**: Recipient Unavailable

**category**: Alert

**medium**: written

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**topic**: Hyperkalemia

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**sent**: 2014-12-12 18:01:10-0800

**received**: 2014-12-12 18:01:11-0800

**recipient**: [Practitioner Adam Careful](Practitioner-example.md)

**sender**: [Device: identifier = http://example.org/devices/id#345675,Serial Number: AMID-342135-8464; status = active; manufacturer = Acme Devices, Inc; lotNumber = 43453424; modelNumber = AB 45-J; type = Electrocardiographic monitor and recorder; contact = ph: ext 4352; note = QA Checked](Device-example.md)

> **payload****content**: Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)

> **payload****content**: Serum Potassium Observation



## Resource Content

```json
{
  "resourceType" : "Communication",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communication"
    ]
  },
  "language" : "en",
  "partOf" : [
    {
      "display" : "Serum Potassium Observation"
    }
  ],
  "status" : "on-hold",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/communication-not-done-reason",
        "code" : "recipient-unavailable"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "alert"
        }
      ],
      "text" : "Alert"
    }
  ],
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "WRITTEN",
          "display" : "written"
        }
      ],
      "text" : "written"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "topic" : {
    "text" : "Hyperkalemia"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "sent" : "2014-12-12T18:01:10-08:00",
  "received" : "2014-12-12T18:01:11-08:00",
  "recipient" : [
    {
      "reference" : "Practitioner/example"
    }
  ],
  "sender" : {
    "reference" : "Device/example"
  },
  "payload" : [
    {
      "contentString" : "Patient 1 has a very high serum potassium value (7.2 mmol/L on 2014-Dec-12 at 5:55 pm)"
    },
    {
      "contentReference" : {
        "display" : "Serum Potassium Observation"
      }
    }
  ]
}

```
