# ClaimResponse example - QI-Core Implementation Guide v8.0.0-ballot

## Example ClaimResponse: ClaimResponse example

Language: en

Profile: [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md)

**status**: Active

**type**: Vision

**use**: Preauthorization

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**created**: 2018-02-24

**insurer**: [Organization Health Level Seven International](Organization-example.md)

**requestor**: [Practitioner Adam Careful](Practitioner-example.md)

**request**: [Claim: identifier = http://example.org/claim#6612346; status = active; type = Vision; use = claim; created = 2014-08-16; priority = Normal](Claim-example.md)

**outcome**: Queued

> **item****itemSequence**: 1
> **adjudication****category**:Submitted Amount

### Amounts

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 235.40 | United States dollar |





## Resource Content

```json
{
  "resourceType" : "ClaimResponse",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claimresponse"
    ]
  },
  "language" : "en",
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "vision"
      }
    ]
  },
  "use" : "preauthorization",
  "patient" : {
    "reference" : "Patient/example"
  },
  "created" : "2018-02-24",
  "insurer" : {
    "reference" : "Organization/example"
  },
  "requestor" : {
    "reference" : "Practitioner/example"
  },
  "request" : {
    "reference" : "Claim/example"
  },
  "outcome" : "queued",
  "item" : [
    {
      "itemSequence" : 1,
      "adjudication" : [
        {
          "category" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/adjudication",
                "code" : "submitted"
              }
            ]
          },
          "amount" : {
            "value" : 235.40,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
