# AdverseEvent example - QI-Core Implementation Guide v8.0.0-ballot

## Example AdverseEvent: AdverseEvent example

Language: en

Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md)

**identifier**: `http://acme.com/ids/patients/risks`/49476534

**actuality**: Adverse Event

**event**: Generalized rash (disorder)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**date**: 2017-01-29 12:34:56+0000

**seriousness**: Non-serious

**recorder**: [Practitioner Adam Careful](Practitioner-example.md)

### SuspectEntities

| | |
| :--- | :--- |
| - | **Instance** |
| * | [Medication alemtuzumab 10 MG/ML [Lemtrada]](Medication-example.md) |



## Resource Content

```json
{
  "resourceType" : "AdverseEvent",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-adverseevent"
    ]
  },
  "language" : "en",
  "identifier" : {
    "system" : "http://acme.com/ids/patients/risks",
    "value" : "49476534"
  },
  "actuality" : "actual",
  "event" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "725119006",
        "display" : "Generalized rash (disorder)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "date" : "2017-01-29T12:34:56+00:00",
  "seriousness" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/adverse-event-seriousness",
        "code" : "non-serious",
        "display" : "Non-serious"
      }
    ]
  },
  "recorder" : {
    "reference" : "Practitioner/example"
  },
  "suspectEntity" : [
    {
      "instance" : {
        "reference" : "Medication/example"
      }
    }
  ]
}

```
