<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile NutritionOrder
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>NutritionOrder</sch:title>
    <sch:rule context="f:NutritionOrder">
      <sch:assert test="not(parent::f:contained and f:contained)">If the resource is contained in another resource, it SHALL NOT contain nested Resources (inherited)</sch:assert>
      <sch:assert test="not(exists(for $id in f:contained/*/f:id/@value return $contained[not(parent::*/descendant::f:reference/@value=concat('#', $contained/*/id/@value) or descendant::f:reference[@value='#'])]))">If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource (inherited)</sch:assert>
      <sch:assert test="not(exists(f:contained/*/f:meta/f:versionId)) and not(exists(f:contained/*/f:meta/f:lastUpdated))">If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated (inherited)</sch:assert>
      <sch:assert test="not(exists(f:contained/*/f:meta/f:security))">If a resource is contained in another resource, it SHALL NOT have a security label (inherited)</sch:assert>
      <sch:assert test="exists(f:text/h:div)">A resource should have narrative for robust management (inherited)</sch:assert>
      <sch:assert test="exists(f:oralDiet) or exists(f:supplement) or exists(f:enteralFormula)">Nutrition Order SHALL contain either Oral Diet , Supplement, or Enteral Formula class (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.meta</sch:title>
    <sch:rule context="f:NutritionOrder/f:meta">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.implicitRules</sch:title>
    <sch:rule context="f:NutritionOrder/f:implicitRules">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.language</sch:title>
    <sch:rule context="f:NutritionOrder/f:language">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.text</sch:title>
    <sch:rule context="f:NutritionOrder/f:text">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.identifier</sch:title>
    <sch:rule context="f:NutritionOrder/f:identifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.instantiatesCanonical</sch:title>
    <sch:rule context="f:NutritionOrder/f:instantiatesCanonical">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.instantiatesUri</sch:title>
    <sch:rule context="f:NutritionOrder/f:instantiatesUri">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.instantiates</sch:title>
    <sch:rule context="f:NutritionOrder/f:instantiates">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.status</sch:title>
    <sch:rule context="f:NutritionOrder/f:status">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.intent</sch:title>
    <sch:rule context="f:NutritionOrder/f:intent">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.patient</sch:title>
    <sch:rule context="f:NutritionOrder/f:patient">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.encounter</sch:title>
    <sch:rule context="f:NutritionOrder/f:encounter">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.dateTime</sch:title>
    <sch:rule context="f:NutritionOrder/f:dateTime">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.orderer</sch:title>
    <sch:rule context="f:NutritionOrder/f:orderer">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.allergyIntolerance</sch:title>
    <sch:rule context="f:NutritionOrder/f:allergyIntolerance">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.foodPreferenceModifier</sch:title>
    <sch:rule context="f:NutritionOrder/f:foodPreferenceModifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.excludeFoodModifier</sch:title>
    <sch:rule context="f:NutritionOrder/f:excludeFoodModifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.type</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.schedule</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:schedule">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.nutrient</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:nutrient">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.nutrient.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:nutrient/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.nutrient.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:nutrient/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.nutrient.modifier</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:nutrient/f:modifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.nutrient.amount</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:nutrient/f:amount">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.texture</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:texture">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.texture.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:texture/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.texture.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:texture/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.texture.modifier</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:texture/f:modifier">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.texture.foodType</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:texture/f:foodType">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.fluidConsistencyType</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:fluidConsistencyType">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.oralDiet.instruction</sch:title>
    <sch:rule context="f:NutritionOrder/f:oralDiet/f:instruction">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.type</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:type">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.productName</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:productName">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.schedule</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:schedule">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.quantity</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:quantity">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.supplement.instruction</sch:title>
    <sch:rule context="f:NutritionOrder/f:supplement/f:instruction">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.baseFormulaType</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:baseFormulaType">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.baseFormulaProductName</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:baseFormulaProductName">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.additiveType</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:additiveType">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.additiveProductName</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:additiveProductName">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.caloricDensity</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:caloricDensity">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.routeofAdministration</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:routeofAdministration">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration.extension</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration.modifierExtension</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration/f:modifierExtension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration.schedule</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration/f:schedule">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration.quantity</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration/f:quantity">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administration.rate[x] 1</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administration/f:rate[x]">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.maxVolumeToDeliver</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:maxVolumeToDeliver">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.enteralFormula.administrationInstruction</sch:title>
    <sch:rule context="f:NutritionOrder/f:enteralFormula/f:administrationInstruction">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>NutritionOrder.note</sch:title>
    <sch:rule context="f:NutritionOrder/f:note">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
